/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.ExcelUtils;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.data.AbstractDataModel;
import com.fr.general.FRLogger;
import com.fr.general.data.TableDataException;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFRow;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFSheet;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Sheet;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Workbook;
import com.fr.third.v2.org.apache.poi.ss.usermodel.WorkbookFactory;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class ExcelDataModel
extends AbstractDataModel {
    private int columnCount = 0;
    private List<Object> columnNameList = new ArrayList<Object>();
    private List<Object[]> rowDataList = new ArrayList<Object[]>();
    private boolean needColumnName;
    private String filePath;
    private Parameter[] params;

    public ExcelDataModel(String string, boolean bl, Parameter[] parameterArray) {
        this.filePath = string;
        this.needColumnName = bl;
        this.params = parameterArray;
    }

    public int getColumnCount() throws TableDataException {
        this.initData();
        return this.columnCount;
    }

    public String getColumnName(int n) throws TableDataException {
        this.initData();
        String string = "#" + (n + 1);
        if (this.needColumnName) {
            return n < this.columnNameList.size() ? this.columnNameList.get(n).toString() : string;
        }
        return string;
    }

    public int getRowCount() throws TableDataException {
        this.initData();
        return this.rowDataList.size();
    }

    public Object getValueAt(int n, int n2) throws TableDataException {
        this.initData();
        if (n2 >= this.rowDataList.get(n).length) {
            return null;
        }
        return this.rowDataList.get(n)[n2];
    }

    private void initData() {
        if (!this.rowDataList.isEmpty()) {
            return;
        }
        try {
            ExcelUtils.checkThirdJarPOI();
            this.initExcel7Data();
        }
        catch (Exception exception) {
            this.initExcel3Data();
        }
        if (this.needColumnName && this.rowDataList.size() > 0) {
            this.columnNameList = Arrays.asList((Object[])this.rowDataList.get(0));
            this.rowDataList.remove(0);
        }
    }

    private void initExcel3Data() {
        try {
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(this.getfileInputStream());
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(pOIFSFileSystem);
            int n = hSSFWorkbook.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(i);
                int n2 = hSSFSheet.getFirstRowNum();
                int n3 = hSSFSheet.getLastRowNum();
                if (n3 == 0 && hSSFSheet.getRow(0) == null) continue;
                for (int j = n2; j <= n3; ++j) {
                    HSSFRow hSSFRow = hSSFSheet.getRow(j);
                    if (hSSFRow == null) continue;
                    short s = hSSFRow.getLastCellNum();
                    if (s > this.columnCount) {
                        this.columnCount = s;
                    }
                    Object[] objectArray = new Object[this.columnCount];
                    for (int k = 0; k < this.columnCount; ++k) {
                        HSSFCell hSSFCell = hSSFRow.getCell(k);
                        objectArray[k] = ExcelUtils.getHSSFCellValueNoFormula(hSSFCell);
                    }
                    this.rowDataList.add(objectArray);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FRLogger.getLogger().error(fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
    }

    private void initExcel7Data() {
        try {
            InputStream inputStream = this.getfileInputStream();
            if (inputStream == null) {
                return;
            }
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            int n = workbook.getNumberOfSheets();
            for (int i = 0; i < n; ++i) {
                Sheet sheet = workbook.getSheetAt(i);
                int n2 = sheet.getFirstRowNum();
                int n3 = sheet.getLastRowNum();
                if (n3 == 0 && sheet.getRow(0) == null) continue;
                for (int j = n2; j <= n3; ++j) {
                    Row row = sheet.getRow(j);
                    short s = row.getLastCellNum();
                    if (s > this.columnCount) {
                        this.columnCount = s;
                    }
                    Object[] objectArray = new Object[this.columnCount];
                    for (int k = 0; k < this.columnCount; ++k) {
                        Cell cell = row.getCell(k, Row.CREATE_NULL_AS_BLANK);
                        objectArray[k] = ExcelUtils.getCellValueNoFormula(cell);
                    }
                    this.rowDataList.add(objectArray);
                }
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
        }
    }

    public void release() throws Exception {
    }

    private InputStream getfileInputStream() {
        try {
            this.filePath = ParameterHelper.analyze4Templatee(this.filePath, this.params);
            if (this.filePath.indexOf("http") != -1) {
                URL uRL = new URL(this.filePath);
                URLConnection uRLConnection = uRL.openConnection();
                return uRLConnection.getInputStream();
            }
            return new FileInputStream(this.filePath);
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
            return null;
        }
    }
}

