/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.DataModelCreator;
import com.fr.base.Parameter;
import com.fr.base.ParameterHelper;
import com.fr.base.SynchronizedLiveDataModelUtils;
import com.fr.data.AbstractParameterTableData;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.AbstractDBDataModel;
import com.fr.data.impl.Connection;
import com.fr.data.impl.DiskCacheDBDataModel;
import com.fr.data.impl.EscapeSqlHelper;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.MemCachedDBDataModel;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.lazycalkey.TableDataSqlIdentifier;
import com.fr.general.ComparatorUtils;
import com.fr.general.data.DataModel;
import com.fr.general.sql.SqlUtils;
import com.fr.script.Calculator;
import com.fr.stable.ParameterProvider;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.ObjectHolder;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.DataModelFillProcessor;
import com.fr.stable.fun.DataQueryProcessor;
import com.fr.stable.fun.TableDataProvider;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTableData
extends AbstractParameterTableData
implements XMLable {
    private static final String ACCESS_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private Connection database;
    private String query;
    private boolean share = false;
    private int maxMemRowCount = -1;
    private String pageQuerySql = null;
    private DataQueryProcessor dataQueryProcessor;

    public DBTableData() {
        this(ACCESS_DRIVER, "", "", "", "");
    }

    public DBTableData(String string, String string2, String string3, String string4, String string5) {
        this(new JDBCDatabaseConnection(string, string2, string3, string4), string5);
    }

    public DBTableData(Connection connection, String string) {
        this.setDatabase(connection);
        this.setQuery(string);
    }

    public Connection getDatabase() {
        return this.database;
    }

    public void setDatabase(Connection connection) {
        this.database = connection;
    }

    public String getQuery() {
        return this.query;
    }

    public String getPageQuerySql() {
        return this.pageQuerySql;
    }

    public void setPageQuerySql(String string) {
        this.pageQuerySql = string;
    }

    public int getMaxMemRowCount() {
        return this.maxMemRowCount;
    }

    public void setMaxMemRowCount(int n) {
        this.maxMemRowCount = n;
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean bl) {
        this.share = bl;
    }

    public boolean isShareTableData() {
        return this.share;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    @Override
    public DataModel createDataModel(Calculator calculator) {
        return this.createDataModel(calculator, 1);
    }

    @Override
    public DataModel createDataModelWithTimeout(Calculator calculator, int n) {
        return this.createDataModel(calculator, 1, n);
    }

    private String getStatementSql(Calculator calculator, int n) {
        String string;
        Parameter[] parameterArray = this.processParameters(calculator);
        Set<TableDataProvider> set = this.getTableDataProviders();
        this.processExtraParas(parameterArray, calculator, set);
        String string2 = string = this.getNewQuery(parameterArray);
        if (n == 0 && !ComparatorUtils.equals(this.getDatabase().getDriver(), ACCESS_DRIVER)) {
            string2 = SqlUtils.tryConvertToNoRecord(string);
        }
        string2 = this.processExtraSQL(parameterArray, string2, calculator, set);
        return string2;
    }

    private String getStatementSql(Calculator calculator) {
        return this.getStatementSql(calculator, 0);
    }

    public DataModel createDataModel(Calculator calculator, int n, int n2) {
        DataModelFillProcessor dataModelFillProcessor;
        String string = this.getStatementSql(calculator, n);
        DataModelCreator dataModelCreator = SynchronizedLiveDataModelUtils.getSheetExecutor();
        DataModel dataModel = dataModelCreator != null ? dataModelCreator.createDBDataModel(this, string) : SynchronizedLiveDataModelUtils.createDefaultDBDataModel(this, string, n2);
        if (calculator == null) {
            return dataModel;
        }
        TableDataSource tableDataSource = (TableDataSource)calculator.getAttribute(TableDataSource.KEY);
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (dataModelFillProcessor = (DataModelFillProcessor)extraClassManagerProvider.getSingle("DataModelFillProcessor")) != null && dataModelFillProcessor.isSupportedType(new ObjectHolder(calculator))) {
            TableDataSqlIdentifier tableDataSqlIdentifier = new TableDataSqlIdentifier(tableDataSource, string);
            dataModel = dataModelFillProcessor.getOrCreate(new ObjectHolder(dataModel), tableDataSqlIdentifier).get(DataModel.class);
        }
        return dataModel;
    }

    @Override
    public DataModel createDataModel(Calculator calculator, int n) {
        return this.createDataModel(calculator, n, 0);
    }

    private Set<TableDataProvider> getTableDataProviders() {
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider == null) {
            return new HashSet<TableDataProvider>();
        }
        return extraClassManagerProvider.getArray("TableDataProvider", EscapeSqlHelper.getInstance());
    }

    private String processExtraSQL(Parameter[] parameterArray, String string, Calculator calculator, Set<TableDataProvider> set) {
        for (TableDataProvider tableDataProvider : set) {
            String string2 = tableDataProvider.processTableDataSQL(parameterArray, string, calculator);
            if (!StringUtils.isNotEmpty(string2)) continue;
            string = string2;
        }
        return string;
    }

    private void processExtraParas(Parameter[] parameterArray, Calculator calculator, Set<TableDataProvider> set) {
        for (TableDataProvider tableDataProvider : set) {
            tableDataProvider.processParametersBeforeAnalyzeSQL(parameterArray, calculator);
        }
    }

    public static AbstractDBDataModel createCacheableDBResultSet(Connection connection, String string, long l) {
        AbstractDBDataModel abstractDBDataModel = new DiskCacheDBDataModel(connection, string);
        if (l < 0L) {
            abstractDBDataModel = new MemCachedDBDataModel(connection, string);
        } else {
            int n = abstractDBDataModel.shortcutGetRowCount();
            if (n >= 0 && (long)n < l) {
                abstractDBDataModel = new MemCachedDBDataModel(connection, string);
            }
        }
        return abstractDBDataModel;
    }

    protected Parameter[] processParameters(Calculator calculator) {
        if (this.parameters == null || ComparatorUtils.equals(this.parameters, new Parameter[0])) {
            this.parameters = ParameterHelper.analyze4Parameters(this.getQuery(), false);
        }
        return Parameter.providers2Parameter(Calculator.processParameters(calculator, this.parameters));
    }

    protected String getNewQuery(Parameter[] parameterArray) {
        return ParameterHelper.analyzeCurrentContextTableData4Templatee(this.getQuery(), parameterArray);
    }

    @Override
    public void setParameters(ParameterProvider[] parameterProviderArray) {
        this.parameters = parameterProviderArray;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("Attributes".equals(string)) {
                this.setShare(xMLableReader.getAttrAsBoolean("share", false));
                this.setMaxMemRowCount(xMLableReader.getAttrAsInt("maxMemRowCount", -1));
            } else if ("Connection".equals(string) || "Database".equals(string)) {
                if (xMLableReader.getAttrAsString("class", null) != null) {
                    Connection connection = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                    this.setDatabase(connection);
                }
            } else if ("Query".equals(string)) {
                String string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setQuery(string2);
                }
            } else if ("PageQuery".equals(string)) {
                String string3 = xMLableReader.getElementValue();
                if (string3 != null) {
                    this.setPageQuerySql(string3);
                }
            } else if ("DataQuery".equals(string)) {
                this.readQueryText(xMLableReader);
            }
        }
    }

    private void readQueryText(XMLableReader xMLableReader) {
        DataQueryProcessor dataQueryProcessor;
        ExtraClassManagerProvider extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class);
        if (extraClassManagerProvider != null && (dataQueryProcessor = (DataQueryProcessor)extraClassManagerProvider.getSingle("DataQueryProcessor")) != null) {
            this.dataQueryProcessor = dataQueryProcessor.newInstance();
            this.dataQueryProcessor.readXML(xMLableReader);
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("Attributes");
        if (this.share) {
            xMLPrintWriter.attr("share", this.share);
        }
        xMLPrintWriter.attr("maxMemRowCount", this.getMaxMemRowCount()).end();
        if (this.database != null) {
            DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, this.database);
        }
        xMLPrintWriter.startTAG("Query").textNode(this.getQuery()).end();
        if (this.pageQuerySql != null) {
            xMLPrintWriter.startTAG("PageQuery").textNode(this.pageQuerySql).end();
        }
        if (this.dataQueryProcessor != null) {
            this.dataQueryProcessor.writeXML(xMLPrintWriter);
        }
    }

    public String toString() {
        return this.database + "[Query:" + this.getQuery() + "]";
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DBTableData dBTableData = (DBTableData)super.clone();
        dBTableData.setDatabase(this.getDatabase());
        dBTableData.setQuery(this.getQuery());
        dBTableData.setMaxMemRowCount(this.getMaxMemRowCount());
        dBTableData.setPageQuerySql(this.getPageQuerySql());
        dBTableData.setDataQueryProcessor(this.getDataQueryProcessor());
        return dBTableData;
    }

    @Override
    public void registerNoPrivilege(ArrayList<String> arrayList, String string, String string2) {
        String string3;
        Connection connection = this.getDatabase();
        if (connection instanceof NameDatabaseConnection && ComparatorUtils.equals(string, string3 = ((NameDatabaseConnection)connection).getName())) {
            arrayList.add(string2);
        }
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof DBTableData && super.equals(object) && ComparatorUtils.equals(this.query, ((DBTableData)object).query) && ComparatorUtils.equals(this.database, ((DBTableData)object).database) && this.maxMemRowCount == ((DBTableData)object).maxMemRowCount && ComparatorUtils.equals(this.pageQuerySql, ((DBTableData)object).pageQuerySql) && ComparatorUtils.equals(this.dataQueryProcessor, ((DBTableData)object).dataQueryProcessor);
    }

    public DataQueryProcessor getDataQueryProcessor() {
        return this.dataQueryProcessor;
    }

    public void setDataQueryProcessor(DataQueryProcessor dataQueryProcessor) {
        this.dataQueryProcessor = dataQueryProcessor;
    }
}

