/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.data.impl.Connection;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabaseConnection
implements Connection {
    private String originalCharsetName = null;
    private String newCharsetName = null;

    @Override
    public String getOriginalCharsetName() {
        return this.originalCharsetName;
    }

    @Override
    public void setOriginalCharsetName(String string) {
        this.originalCharsetName = string;
    }

    @Override
    public String getNewCharsetName() {
        return this.newCharsetName;
    }

    @Override
    public void setNewCharsetName(String string) {
        this.newCharsetName = string;
    }

    @Override
    public void addConnection(List<String> list, String string, Class<? extends Connection>[] classArray) {
        for (Class<? extends Connection> clazz : classArray) {
            if (!StableUtils.objectInstanceOf(this, clazz)) continue;
            list.add(string);
            break;
        }
    }

    @Override
    public String connectMessage(boolean bl) {
        if (bl) {
            return Inter.getLocText("Datasource-Connection_successfully") + "!";
        }
        return Inter.getLocText("Datasource-Connection_failed") + "!";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractDatabaseConnection)) {
            return false;
        }
        return ComparatorUtils.equals(this.getOriginalCharsetName(), ((Connection)object).getOriginalCharsetName()) && ComparatorUtils.equals(this.getNewCharsetName(), ((Connection)object).getNewCharsetName());
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode() && "DatabaseAttr".equals(xMLableReader.getTagName())) {
            this.setOriginalCharsetName(xMLableReader.getAttrAsString("originalCharsetName", null));
            this.setNewCharsetName(xMLableReader.getAttrAsString("newCharsetName", null));
        }
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("DatabaseAttr");
        if (this.getOriginalCharsetName() != null) {
            xMLPrintWriter.attr("originalCharsetName", this.getOriginalCharsetName());
        }
        if (this.getNewCharsetName() != null) {
            xMLPrintWriter.attr("newCharsetName", this.getNewCharsetName());
        }
        xMLPrintWriter.end();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String feature() {
        return "";
    }

    @Override
    public boolean hasSchema() {
        return false;
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        throw new UnsupportedOperationException();
    }
}

