/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.CoreDecimalFormat;
import com.fr.base.TextFormat;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.ArrayUtils;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FormatField {
    private static FormatField format;
    private static final double DOUBLE_VALUE = 12345.6789;
    private final String NULL = Inter.getLocText("StyleFormat-None");
    private final String NUMBER = Inter.getLocText("Number");
    private final String CURRENCY = Inter.getLocText("StyleFormat-Currency");
    private final String PERCENT = Inter.getLocText("StyleFormat-Percent");
    private final String SCIENTIFIC = Inter.getLocText("StyleFormat-Scientific");
    private final String DATE = Inter.getLocText("StyleFormat-Date");
    private final String TIME = Inter.getLocText("StyleFormat-Time");
    private final String TEXT = Inter.getLocText("StyleFormat-Text");
    private final String[] noneArray = new String[0];
    private final String[] numberArray = new String[]{"#0", "#0.00", "#0.0#", "#,##0", "#,##0.00"};
    private final String[] currencyArray = new String[]{"\u00a4#0", "\u00a4#0.00", "\u00a4#,##0", "\u00a4#,##0.0", "\u00a4#,##0.00", "\u00a4#,##0;\u00a4-#,##0", "\u00a4#,##0.00;\u00a4-#,##0.00", "\u00a4#,##0.00;(\u00a4#,##0.00)", "$#,##0;($#,##0)", "$#,##0.00;($#,##0.00)", "#,##0;-#,##0"};
    private final String[] percentArray = new String[]{"#0%", "#0.0%", "#0.00%", "#0.000%", "#0.0000%"};
    private final String[] scientficArray = new String[]{"0.00E00", "##0.0E0"};
    private final String[] dateArray = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", "yyyy-M-d", "yyyy/M/d", "yyyy-MM", "yyyy/MM", "MM/dd/yyyy", "EEEEE, MMMMM dd, yyyy", "MMMM d, yyyy", "MM/d/yy", "d-MMM-yy", "MM.d.yyyy", "MMM. d, yyyy", "d MMMMM yyyy", "MMMMM yy", "MM-yy", "d-MMM", "M-d-yy"};
    private final String[] timeArray = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd hh:mm:ss", "yyyy-M-d h:mm", "yyyy-M-d H:mm", "HH:mm:ss", "hh:mm:ss", "MM/dd/yyyy hh:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss a", "MM/dd/yyyy HH:mm:ss a", "MM/dd/yyyy h:mm a", "MM/dd/yyyy H:mm a", "h:mm", "H:mm", "h:mm:ss", "H:mm:ss", "hh:mm", "HH:mm", "mm:ss", "mm:ss.0", "[h]:mm:ss", "[H]:mm:ss", "h:mm:ss a", "HH:mm:ss a", "h:mm:ss a, z", "HH:mm:ss a, z"};
    private final String[] dateArray4Widget = new String[]{"yyyy-MM-dd", "yyyy/MM/dd", Inter.getLocText("DateFormat-yyyyMMdd"), "yyyy-M-d", "yyyy/M/d", Inter.getLocText("DateFormat-yyyyMd"), "yyyy-MM", "yyyy/MM", Inter.getLocText("DateFormat-yyyyMM"), "MM/dd/yyyy", "MM/d/yy", "MM.dd.yyyy", "MM.d.yyyy", "MM-yy", "M-d-yy"};
    private final String[] timeArray4Widget = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd hh:mm:ss", "yyyy/MM/dd hh:mm:ss", "yyyy-MM-dd HH:mm:ss a", "yyyy/MM/dd HH:mm:ss a", "yyyy-MM-dd hh:mm:ss a", "yyyy/MM/dd hh:mm:ss a", "MM/dd/yyyy hh:mm:ss", "MM/dd/yyyy HH:mm:ss", "MM/dd/yyyy hh:mm:ss a", "MM/dd/yyyy HH:mm:ss a", "MM/dd/yyyy h:mm a", "MM/dd/yyyy H:mm a", "yyyy-M-d h:mm", "yyyy-M-d H:mm", "h:mm:ss a", "HH:mm:ss a", "HH:mm:ss", "hh:mm:ss", "h:mm", "H:mm", "h:mm:ss", "H:mm:ss", "hh:mm", "HH:mm", "mm:ss"};
    private final String[] textArray = new String[0];

    public static FormatField getInstance() {
        if (format == null) {
            format = new FormatField();
        }
        return format;
    }

    public JSONArray createJSONArray() throws Exception {
        JSONArray jSONArray = new JSONArray();
        jSONArray.put(new FormatMap(0).createJSON());
        jSONArray.put(new FormatMap(1).createJSON());
        jSONArray.put(new FormatMap(2).createJSON());
        jSONArray.put(new FormatMap(3).createJSON());
        jSONArray.put(new FormatMap(4).createJSON());
        jSONArray.put(new FormatMap(5).createJSON());
        jSONArray.put(new FormatMap(6).createJSON());
        jSONArray.put(new FormatMap(7).createJSON());
        return jSONArray;
    }

    public int getContents(Object object) {
        if (ComparatorUtils.equals((Object)this.NULL, object)) {
            return 0;
        }
        if (ComparatorUtils.equals((Object)this.NUMBER, object)) {
            return 1;
        }
        if (ComparatorUtils.equals((Object)this.CURRENCY, object)) {
            return 2;
        }
        if (ComparatorUtils.equals((Object)this.PERCENT, object)) {
            return 3;
        }
        if (ComparatorUtils.equals((Object)this.SCIENTIFIC, object)) {
            return 4;
        }
        if (ComparatorUtils.equals((Object)this.DATE, object)) {
            return 5;
        }
        if (ComparatorUtils.equals((Object)this.TEXT, object)) {
            return 7;
        }
        if (ComparatorUtils.equals((Object)this.TIME, object)) {
            return 6;
        }
        return 0;
    }

    public String getName(int n) {
        switch (n) {
            case 0: {
                return this.NULL;
            }
            case 1: {
                return this.NUMBER;
            }
            case 2: {
                return this.CURRENCY;
            }
            case 3: {
                return this.PERCENT;
            }
            case 4: {
                return this.SCIENTIFIC;
            }
            case 5: {
                return this.DATE;
            }
            case 6: {
                return this.TIME;
            }
            case 7: {
                return this.TEXT;
            }
        }
        return this.NULL;
    }

    public String[] getFormatArray(int n) {
        return this.getFormatArray(n, true);
    }

    public String[] getFormatArray(int n, boolean bl) {
        switch (n) {
            case 0: {
                return this.noneArray;
            }
            case 1: {
                return this.numberArray;
            }
            case 2: {
                return this.currencyArray;
            }
            case 3: {
                return this.percentArray;
            }
            case 4: {
                return this.scientficArray;
            }
            case 5: {
                return bl ? this.dateArray4Widget : this.dateArray;
            }
            case 6: {
                return bl ? this.timeArray4Widget : this.timeArray;
            }
            case 7: {
                return this.textArray;
            }
        }
        return this.noneArray;
    }

    public String[] getDateFormatArray() {
        return ArrayUtils.addAll(this.getFormatArray(5), this.getFormatArray(6));
    }

    public String getFormatValue() {
        return this.getFormatValue(0, null);
    }

    public String getFormatValue(int n, String string) {
        if (n <= 4 && n > 0) {
            if (string != null && string.length() > 0) {
                CoreDecimalFormat coreDecimalFormat = new CoreDecimalFormat(new DecimalFormat(string), string);
                return coreDecimalFormat.formatRoundingModeUp(new Double(12345.6789));
            }
        } else if (n == 5 || n == 6) {
            if (string != null && string.length() > 0) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                return simpleDateFormat.format(new Date());
            }
            return new Date().toString();
        }
        return "12345.6789";
    }

    public Format getFormat(int n, String string) {
        if (n <= 4 && n > 0) {
            if (string != null && string.length() > 0) {
                try {
                    return new CoreDecimalFormat(new DecimalFormat(string), string);
                }
                catch (Exception exception) {
                    return new DecimalFormat("");
                }
            }
            return new DecimalFormat("");
        }
        if (n == 5 || n == 6) {
            if (string != null && string.length() > 0) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                    simpleDateFormat.format(new Date());
                    return simpleDateFormat;
                }
                catch (Exception exception) {
                    return new SimpleDateFormat("");
                }
            }
            return new SimpleDateFormat("");
        }
        if (n == 7) {
            return TextFormat.getInstance();
        }
        return null;
    }

    private static class FormatMap {
        private String key;
        private String[] value;
        private int contents;

        public FormatMap(int n) {
            this.contents = n;
            this.setKey(FormatField.getInstance().getName(n));
            this.setValue(FormatField.getInstance().getFormatArray(n));
        }

        public JSONObject createJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("key", this.getKey());
            jSONObject.put("value", this.getValue());
            jSONObject.put("contents", this.contents);
            return jSONObject;
        }

        public String getKey() {
            return this.key;
        }

        private void setKey(String string) {
            this.key = string;
        }

        public String[] getValue() {
            return this.value;
        }

        private void setValue(String[] stringArray) {
            this.value = stringArray;
        }
    }

    public static class FormatContents {
        public static final int NULL = 0;
        public static final int NUMBER = 1;
        public static final int CURRENCY = 2;
        public static final int PERCENT = 3;
        public static final int SCIENTIFIC = 4;
        public static final int DATE = 5;
        public static final int TIME = 6;
        public static final int TEXT = 7;
    }
}

