/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.data.PresentationType;
import com.fr.data.cache.AttachmentCacheManager;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.core.db.handler.BlobDelegate;
import com.fr.data.core.db.handler.ClobDelegate;
import com.fr.file.WebImage;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.stable.Primitive;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.ImageParserProcessor;
import com.fr.stable.plugin.ExtraClassManagerProvider;
import com.fr.stable.xml.FRFile;
import com.fr.third.JAI.ByteArraySeekableStream;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class DataUtils {
    public static final String REQ_IN = "__inputstream__";
    private static final int BYTE_LENGTH = 10;

    private DataUtils() {
    }

    public static String clob2String(Clob clob) {
        if (clob == null) {
            return "";
        }
        try {
            return DataUtils.reader2String(clob.getCharacterStream());
        }
        catch (SQLException sQLException) {
            FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            return "";
        }
    }

    public static String reader2String(Reader reader) {
        if (reader == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        try {
            IOUtils.copyCharTo(reader, stringWriter);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            reader.close();
            stringWriter.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            try {
                reader.close();
            }
            catch (IOException iOException2) {
                FRLogger.getLogger().error(iOException2.getMessage(), iOException2);
            }
            try {
                stringWriter.close();
            }
            catch (IOException iOException3) {
                FRLogger.getLogger().error(iOException3.getMessage(), iOException3);
            }
            return "";
        }
    }

    public static Object resolveOtherValue(Object object, boolean bl, boolean bl2, Object object2) {
        return DataUtils.resolveOtherValue(object, bl, bl2, object2, true);
    }

    public static Object resolveOtherValue(Object object, boolean bl, boolean bl2, Object object2, boolean bl3) {
        String string;
        if (object instanceof String || object instanceof Primitive) {
            return object;
        }
        String string2 = string = object2 == null ? null : object2.toString();
        if (object instanceof FRFile) {
            FRFile fRFile = (FRFile)object;
            if ("image".equals(fRFile.getType())) {
                try {
                    object = ImageIO.read(new ByteArrayInputStream(fRFile.getBytes()));
                }
                catch (IOException iOException) {
                    FRLogger.getLogger().error(iOException.getMessage(), iOException);
                    return "";
                }
            }
        } else if (object instanceof Clob) {
            object = DataUtils.clob2Object((Clob)object, bl2, string, bl3);
        } else if (object instanceof ClobDelegate) {
            object = DataUtils.clobDelegate2Object((ClobDelegate)object, bl2, string, bl3);
        } else if (object instanceof Blob) {
            object = DataUtils.blob2Object((Blob)object, bl, bl2, string, bl3);
        } else if (object instanceof BlobDelegate) {
            object = DataUtils.blobDelegate2Object((BlobDelegate)object, bl, bl2, string, bl3);
        } else if (object instanceof BinaryObject) {
            BinaryObject binaryObject = (BinaryObject)object;
            object = bl ? binaryObject.getImage() : binaryObject.getValue(bl2, string);
        } else if (object instanceof FArray && bl2) {
            boolean bl4 = object2 instanceof FArray && ((FArray)object2).length() >= ((FArray)object).length();
            for (int i = 0; i < ((FArray)object).length(); ++i) {
                Object object3;
                Object t = ((FArray)object).elementAt(i);
                if (t == (object3 = DataUtils.resolveOtherValue(t, bl, bl2, bl4 ? ((FArray)object2).elementAt(i) : string, bl3))) continue;
                ((FArray)object).setElement(i, object3);
            }
        }
        return object;
    }

    public static Object resolveOtherValue(Object object, boolean bl, boolean bl2, Object object2, boolean bl3, PresentationType presentationType) {
        if (object instanceof WebImage) {
            object = ((WebImage)object).presentationResult(presentationType);
        }
        return DataUtils.resolveOtherValue(object, bl, bl2, object2, bl3);
    }

    private static Object clob2Object(Clob clob, boolean bl, String string, boolean bl2) {
        if (bl) {
            return DataUtils.bytes2Object(DataUtils.clob2String(clob).getBytes(), true, string, bl2);
        }
        return DataUtils.clob2String(clob);
    }

    private static Object clobDelegate2Object(ClobDelegate clobDelegate, boolean bl, String string, boolean bl2) {
        Clob clob = clobDelegate.getClob();
        if (bl) {
            return DataUtils.bytes2Object(clobDelegate.getReader().getBytes(), true, string, bl2);
        }
        if (clob == null) {
            return "";
        }
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
        }
        catch (Exception exception) {
            return clobDelegate.getReader();
        }
        return DataUtils.reader2String(reader);
    }

    private static Object bytes2Object(byte[] byArray, boolean bl, String string, boolean bl2) {
        ExtraClassManagerProvider extraClassManagerProvider;
        ImageParserProcessor imageParserProcessor;
        Image image;
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if ((image = (imageParserProcessor = (ImageParserProcessor)(extraClassManagerProvider = StableFactory.getMarkedObject("ExtraClassManager", ExtraClassManagerProvider.class)).getSingle("ImageParserProcessor")) != null ? imageParserProcessor.parseImage(byArray) : DataUtils.parseImage(byArray)) != null && !bl) {
            return image;
        }
        if (bl2) {
            return new String(byArray);
        }
        String string2 = string != null ? string : "Download" + StableUtils.getFileTypeFromBytes(byArray);
        if (byArray.length < 10 && ComparatorUtils.equals(string2, "Download.txt")) {
            return new String(byArray);
        }
        return AttachmentCacheManager.addAttachment("other", string2, byArray);
    }

    private static Image parseImage(byte[] byArray) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = IOUtils.readImage(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        if (bufferedImage == null) {
            try {
                BufferedImage bufferedImage2;
                ByteArraySeekableStream byteArraySeekableStream = new ByteArraySeekableStream(byArray);
                ImageDecoder imageDecoder = ImageCodec.createImageDecoder((String)"tiff", (SeekableStream)byteArraySeekableStream, null);
                RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage(0);
                Raster raster = renderedImage.getData();
                bufferedImage = bufferedImage2 = new BufferedImage(renderedImage.getColorModel(), Raster.createWritableRaster(renderedImage.getSampleModel(), raster.getDataBuffer(), null), false, new Hashtable());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bufferedImage;
    }

    private static Object delegateObject(BlobDelegate blobDelegate, String string) {
        String string2 = string != null ? string : "Download";
        return AttachmentCacheManager.addAttachment("other", string2, blobDelegate);
    }

    private static Object blob2Object(Blob blob, boolean bl, boolean bl2, String string, boolean bl3) {
        if (bl) {
            try {
                BufferedImage bufferedImage = IOUtils.readImage(blob.getBinaryStream());
                if (bufferedImage != null) {
                    return bufferedImage;
                }
                Object object = DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, null, bl3);
                if (object instanceof Image) {
                    return object;
                }
                return new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        } else {
            try {
                return DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, string, bl3);
            }
            catch (SQLException sQLException) {
                FRLogger.getLogger().error(sQLException.getMessage(), sQLException);
            }
        }
        return null;
    }

    private static Object blobDelegate2Object(BlobDelegate blobDelegate, boolean bl, boolean bl2, String string, boolean bl3) {
        if (bl) {
            try {
                Blob blob = blobDelegate.getBlob();
                BufferedImage bufferedImage = IOUtils.readImage(blob.getBinaryStream());
                if (bufferedImage != null) {
                    return bufferedImage;
                }
                Object object = DataUtils.inputStream2Object(blob.getBinaryStream(), bl2, null, bl3);
                if (object instanceof Image) {
                    return object;
                }
                return new String(blob.getBytes(1L, (int)blob.length()), "UTF-8");
            }
            catch (Exception exception) {
                return DataUtils.bytes2Object(blobDelegate.getValue(), bl2, string, bl3);
            }
        }
        if (bl2) {
            return DataUtils.delegateObject(blobDelegate, string);
        }
        return DataUtils.bytes2Object(blobDelegate.getValue(), bl2, string, bl3);
    }

    public static Object inputStream2Object(InputStream inputStream, boolean bl, String string, boolean bl2) {
        return DataUtils.bytes2Object(IOUtils.inputStream2Bytes(inputStream), bl, string, bl2);
    }

    public static Object inputStream2Object(InputStream inputStream, boolean bl, String string) {
        return DataUtils.bytes2Object(IOUtils.inputStream2Bytes(inputStream), bl, string, true);
    }
}

