/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data;

import com.fr.base.TableData;
import com.fr.base.TableDataNameObserver;
import com.fr.data.TableDataSource;
import com.fr.data.core.DataCoreUtils;
import com.fr.data.core.DataCoreXmlUtils;
import com.fr.data.impl.TableDataSourceDependent;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.file.DatasourceManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractTableDataSource
implements TableDataSource,
TableDataNameObserver {
    public static final String XML_TAG = "TableDataMap";
    protected List tableDataNameList = new ArrayList();
    protected List tableDataList = new ArrayList();

    public Iterator getTableDataNameIterator() {
        return this.tableDataNameList.iterator();
    }

    public TableData getTableData(String string) {
        TableData tableData = null;
        tableData = this.isEmptyTableData(string);
        if (tableData == null) {
            tableData = DataCoreUtils.existsName(string, this);
        }
        return tableData;
    }

    public TableData isEmptyTableData(String string) {
        int n = this.tableDataNameList.indexOf(string);
        return n != -1 ? (TableData)this.tableDataList.get(n) : null;
    }

    public void putTableData(String string, TableData tableData) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (tableData == null) {
            if (n != -1) {
                this.tableDataNameList.remove(n);
                this.tableDataList.remove(n);
            }
        } else if (n != -1) {
            this.tableDataList.set(n, tableData);
        } else {
            this.tableDataNameList.add(string);
            this.tableDataList.add(tableData);
        }
    }

    public boolean renameTableData(String string, String string2) {
        if (string2 == null || string == null) {
            return false;
        }
        if (ComparatorUtils.equals(string, string2)) {
            return false;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.tableDataNameList.set(n, string2);
        return true;
    }

    public void removeTableData(String string) {
        if (string == null) {
            return;
        }
        int n = this.tableDataNameList.indexOf(string);
        if (n != -1) {
            this.tableDataNameList.remove(n);
            this.tableDataList.remove(n);
        }
    }

    public void clearAllTableData() {
        this.tableDataNameList.clear();
        this.tableDataList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && (string = xMLableReader.getTagName()).equals(XML_TAG)) {
            xMLableReader.readXMLObject(new XMLReadable(){

                public void readXML(XMLableReader xMLableReader) {
                    if (xMLableReader.isAttr()) {
                        AbstractTableDataSource.this.clearAllTableData();
                    }
                    if (xMLableReader.isChildNode()) {
                        final String string = xMLableReader.getAttrAsString("name", null);
                        if ("NameTableData".equals(xMLableReader.getTagName())) {
                            xMLableReader.readXMLObject(new XMLReadable(){

                                public void readXML(XMLableReader xMLableReader) {
                                    if (xMLableReader.getTagName().equals("TableData")) {
                                        TableData tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader);
                                        AbstractTableDataSource.this.putTableData(string, tableData);
                                    }
                                }
                            });
                        } else {
                            TableData tableData = DataCoreXmlUtils.readXMLTableData(xMLableReader);
                            AbstractTableDataSource.this.dealWithTableData(tableData, xMLableReader, string);
                            AbstractTableDataSource.this.putTableData(string, tableData);
                        }
                    }
                }
            });
        }
    }

    private void dealWithTableData(TableData tableData, XMLableReader xMLableReader, String string) {
        String string2;
        if (tableData == null && ComparatorUtils.equals(string2 = xMLableReader.getAttrAsString("class", null), "com.fr.data.impl.storeproc.StoreProcedure")) {
            StoreProcedure storeProcedure = null;
            try {
                storeProcedure = (StoreProcedure)GeneralUtils.classForName(string2).newInstance();
            }
            catch (InstantiationException instantiationException) {
                FRLogger.getLogger().error(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                FRLogger.getLogger().error(illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FRLogger.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
            }
            if (storeProcedure != null) {
                xMLableReader.readXMLObject(storeProcedure);
                DatasourceManager.getProviderInstance().putProcedure(string + "from655", storeProcedure);
                return;
            }
        }
        if (tableData instanceof TableDataSourceDependent) {
            ((TableDataSourceDependent)((Object)tableData)).setTableDataSource(this);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        Iterator iterator = this.getTableDataNameIterator();
        if (iterator.hasNext()) {
            xMLPrintWriter.startTAG(XML_TAG);
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                TableData tableData = this.getTableData(string);
                DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, tableData, string);
            }
            xMLPrintWriter.end();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractTableDataSource abstractTableDataSource = (AbstractTableDataSource)super.clone();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.tableDataNameList);
        abstractTableDataSource.tableDataNameList = arrayList;
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < this.tableDataList.size(); ++i) {
            arrayList2.add(((TableData)this.tableDataList.get(i)).clone());
        }
        abstractTableDataSource.tableDataList = arrayList2;
        return abstractTableDataSource;
    }

    protected void copyDataSourceAttr(AbstractTableDataSource abstractTableDataSource) {
        abstractTableDataSource.tableDataList = this.tableDataList;
        abstractTableDataSource.tableDataNameList = this.tableDataNameList;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTableDataSource && ComparatorUtils.equals((Object)this.tableDataNameList, (Object)((AbstractTableDataSource)object).tableDataNameList) && ComparatorUtils.equals((Object)this.tableDataList, (Object)((AbstractTableDataSource)object).tableDataList);
    }
}

