/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.general.FRLogger;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import com.fr.stable.serialize.SerializationUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class ReadOnlyCacheList
extends AbstractList {
    private File diskDirectory = null;
    private int pool_size = 800;
    private String prefix = "ROCache";
    private List diskFileList = new ArrayList();
    private int total_size = 0;
    private int total_pool_size = 0;
    private Object[] lastPool;
    private int lastSize = 0;
    private int cachedPoolIndex = -1;
    private Object[] cachedPool;

    public ReadOnlyCacheList() {
        this.lastPool = new Object[this.pool_size];
    }

    public ReadOnlyCacheList(int n, String string) {
        this.pool_size = n;
        this.prefix = string;
        this.lastPool = new Object[this.pool_size];
    }

    public boolean add(Object object) {
        if (this.lastSize < this.pool_size) {
            this.lastPool[this.lastSize++] = object;
            ++this.total_size;
        }
        if (this.lastSize >= this.pool_size) {
            try {
                File file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
                int n = 0;
                while (file.exists()) {
                    file = new File(this.getCacheDirectory(), this.getPrefix() + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                    ++n;
                }
                file.deleteOnExit();
                SerializationUtils.serializable((Serializable)this.lastPool, file);
                this.lastSize = 0;
                this.diskFileList.add(file);
                this.total_pool_size += this.pool_size;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return true;
    }

    public Object get(int n) {
        if (n >= this.pool_size * this.diskFileList.size()) {
            return this.lastPool[n - this.pool_size * this.diskFileList.size()];
        }
        if (this.cachedPoolIndex >= 0 && this.cachedPoolIndex < this.diskFileList.size() && n >= this.cachedPoolIndex * this.pool_size && n < (this.cachedPoolIndex + 1) * this.pool_size) {
            return this.cachedPool[n - this.cachedPoolIndex * this.pool_size];
        }
        this.flush_cached_pool(n);
        return this.cachedPool[n - this.cachedPoolIndex * this.pool_size];
    }

    private void flush_cached_pool(int n) {
        this.cachedPoolIndex = n / this.pool_size;
        try {
            File file = (File)this.diskFileList.get(this.cachedPoolIndex);
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.cachedPool = (Object[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FRLogger.getLogger().error(classNotFoundException.getMessage(), classNotFoundException);
        }
    }

    public int size() {
        return this.total_size;
    }

    public void clear() {
        this.cachedPoolIndex = -1;
        this.cachedPool = null;
        this.lastPool = new Object[this.pool_size];
        this.lastSize = 0;
        this.total_pool_size = 0;
        this.total_size = 0;
        this.diskFileList.clear();
        if (this.diskDirectory != null) {
            StableUtils.deleteFile(this.diskDirectory);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    private File getCacheDirectory() {
        if (this.diskDirectory == null) {
            this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n = 0;
            while (this.diskDirectory.exists()) {
                this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                ++n;
            }
            StableUtils.mkdirs(this.diskDirectory);
            this.diskDirectory.deleteOnExit();
        }
        return this.diskDirectory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.diskDirectory != null) {
            StableUtils.deleteFile(this.diskDirectory);
        }
    }
}

