/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.CacheException;
import com.fr.cache.FRCache;
import com.fr.cache.MemoryStore;
import com.fr.cache.Unity;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class FifoMemoryStore
extends MemoryStore {
    public FifoMemoryStore(FRCache fRCache) {
        super(fRCache);
        this.map = new LinkedHashMap();
    }

    protected final void doPut(Unity unity) throws CacheException {
        if (this.isFull()) {
            this.removeFirstUnity();
        }
    }

    Unity getFirstUnity() {
        if (this.map.size() == 0) {
            return null;
        }
        Unity unity = null;
        Set set = this.map.keySet();
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            Serializable serializable = (Serializable)iterator.next();
            unity = (Unity)this.map.get(serializable);
        }
        return unity;
    }

    private void removeFirstUnity() throws CacheException {
        Unity unity = this.getFirstUnity();
        if (unity.isExpired()) {
            this.remove(unity.getObjectKey());
            this.notifyExpiry(unity);
            return;
        }
        this.remove(unity.getObjectKey());
        this.evict(unity);
    }
}

