/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache;

import com.fr.cache.CacheConfiguration;
import com.fr.cache.CacheException;
import com.fr.cache.MemoryStore;
import com.fr.cache.MemoryStoreEvictionPolicy;
import com.fr.cache.RegisteredEventListeners;
import com.fr.cache.Status;
import com.fr.cache.Unity;
import java.io.Serializable;

public class FRCache
implements Serializable {
    private Status status = Status.STATUS_UNINITIALISED;
    private MemoryStore memoryStore;
    private CacheConfiguration configuration;
    private RegisteredEventListeners registeredEventListeners;

    public FRCache(CacheConfiguration cacheConfiguration) {
        this.configuration = cacheConfiguration;
        this.memoryStore = MemoryStore.create(this);
        this.registeredEventListeners = new RegisteredEventListeners(this);
        this.status = Status.STATUS_ALIVE;
    }

    public final void put(Object object, Object object2) {
        this.put(new Unity(object, object2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Unity unity) {
        if (unity == null) {
            throw new IllegalArgumentException("Unity can not be null");
        }
        unity.resetAccessStatistics();
        Object object = unity.getObjectKey();
        boolean bl = this.memoryStore.containsKey(object);
        if (bl) {
            unity.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(unity);
        this.backOffIfDiskSpoolFull();
        FRCache fRCache = this;
        synchronized (fRCache) {
            this.memoryStore.put(unity);
        }
    }

    public final Object getObject(Object object) {
        Unity unity = this.get(object);
        return unity != null ? unity.getObjectValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Unity get(Object object) throws IllegalStateException, CacheException {
        Unity unity;
        this.checkStatus();
        FRCache fRCache = this;
        synchronized (fRCache) {
            unity = this.searchInMemoryStore(object, true);
        }
        return unity;
    }

    private Unity searchInMemoryStore(Object object, boolean bl) {
        Unity unity = bl ? this.memoryStore.get(object) : this.memoryStore.getQuiet(object);
        if (unity != null && this.isExpired(unity)) {
            this.remove(object);
            unity = null;
        }
        return unity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Unity unity) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Unity unity2 = unity;
        synchronized (unity2) {
            return unity.isExpired();
        }
    }

    public MemoryStore getStore() {
        return this.memoryStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) throws IllegalStateException {
        Unity unity;
        this.checkStatus();
        FRCache fRCache = this;
        synchronized (fRCache) {
            unity = this.memoryStore.remove(object);
        }
        this.registeredEventListeners.notifyElementExpiry(unity);
        this.registeredEventListeners.notifyElementRemoved(unity);
        return unity != null;
    }

    private void applyDefaultsToElementWithoutLifespanSet(Unity unity) {
        if (!unity.isLifespanSet()) {
            unity.setTimeToLive((int)this.configuration.getTimeToLiveSeconds());
            unity.setTimeToIdle((int)this.configuration.getTimeToIdleSeconds());
        }
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    private void backOffIfDiskSpoolFull() {
    }

    public final int getMaxElementsInMemory() {
        return this.configuration.getMaxElementsInMemory();
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.configuration.getMemoryStoreEvictionPolicy();
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is not alive.");
        }
    }

    private void checkStatusNotDisposed() throws IllegalStateException {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is disposed.");
        }
    }

    public synchronized void dispose() throws IllegalStateException {
        this.checkStatusNotDisposed();
        this.registeredEventListeners.dispose();
        if (this.memoryStore != null) {
            this.memoryStore.dispose();
        }
        this.memoryStore = null;
        this.changeStatus(Status.STATUS_SHUTDOWN);
    }
}

