/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.platform.msg;

import com.fr.base.FRContext;
import com.fr.base.platform.msg.DefaultMessageConverter;
import com.fr.base.platform.msg.Message;
import com.fr.base.platform.msg.MessageConverter;
import com.fr.base.platform.msg.MessageDAOSession;
import com.fr.base.platform.msg.MessageDataAccessObject;
import com.fr.base.platform.msg.MessageDataAccessObjectOperator;
import com.fr.cluster.rpc.RPC;
import com.fr.data.core.db.tableObject.ColumnSize;
import com.fr.data.dao.CommonFieldColumnMapper;
import com.fr.data.dao.DataAccessObjectSession;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.JDBCDataAccessObjectOperator;
import com.fr.data.dao.JDBCDataAccessObjectProperties;
import com.fr.data.dao.ObjectTableMapper;
import com.fr.data.dao.PrimaryKeyFCMapper;
import com.fr.file.BaseClusterHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralMessageDataAccessObject
implements MessageDataAccessObject {
    @Override
    public long save(Message message) throws Exception {
        return this.createSession().save(message);
    }

    @Override
    public boolean delete(Message message) throws Exception {
        return message != null && this.deleteByID(message.getId());
    }

    @Override
    public boolean deleteByID(long l) throws Exception {
        return l >= 0L && this.createSession().deleteByPrimaryKey(this.getDBClass(), l);
    }

    @Override
    public Message findByID(long l) throws Exception {
        return (Message)this.createSession().load(this.getDBClass(), l);
    }

    @Override
    public List<Message> findAll() throws Exception {
        return this.createSession().list(this.getDBClass());
    }

    @Override
    public boolean updateToasted(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("toasted", true);
        return this.createSession().update(this.getDBClass(), l, hashMap);
    }

    @Override
    public boolean updateReaded(long l) throws Exception {
        if (l < 0L) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("readed", true);
        return this.createSession().update(this.getDBClass(), l, hashMap);
    }

    @Override
    public List<Message> getMessagesSortByDate(String string) throws Exception {
        String[] stringArray = new String[]{"username"};
        Object[] objectArray = new Object[]{string};
        int[] nArray = new int[]{0};
        return this.listByFieldsAndSort(stringArray, objectArray, nArray, "createTime", false);
    }

    public List listByFieldsAndSort(String[] stringArray, Object[] objectArray, int[] nArray, String string, boolean bl) throws Exception {
        return this.createSession().listByFieldsAndSort(this.getDBClass(), stringArray, objectArray, nArray, string, bl);
    }

    public List listByFieldValue(String string, Object object) throws Exception {
        return this.createSession().listByFieldValue(this.getDBClass(), string, object);
    }

    public List listByFieldValues(Map map) throws Exception {
        return this.createSession().listByFieldValues(this.getDBClass(), map);
    }

    @Override
    public List<Message> getMessages(long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.converter().convert(l));
        return this.listByFieldValues(hashMap);
    }

    @Override
    public List<Message> getFreshMessages(long l) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("toasted", false);
        hashMap.putAll(this.converter().convert(l));
        return this.listByFieldValues(hashMap);
    }

    @Override
    public List<Message> getMessages(String string) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(this.converter().convert(string));
        return this.listByFieldValues(hashMap);
    }

    @Override
    public List<Message> getFreshMessages(String string) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("toasted", false);
        hashMap.putAll(this.converter().convert(string));
        return this.listByFieldValues(hashMap);
    }

    @Override
    public DataAccessObjectSession createSession() {
        JDBCDataAccessObjectProperties jDBCDataAccessObjectProperties = this.createDataAccessObjectProperties();
        MessageDataAccessObjectOperator messageDataAccessObjectOperator = new MessageDataAccessObjectOperator(jDBCDataAccessObjectProperties.createDatabaseConnection(), jDBCDataAccessObjectProperties.getAllObjTableMappers());
        return this.initSessionCheckCluster(messageDataAccessObjectOperator);
    }

    private DataAccessObjectSession initSessionCheckCluster(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator) {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                try {
                    this.dealCompatibility(jDBCDataAccessObjectOperator);
                }
                catch (Exception exception) {
                    FRContext.getLogger().error(exception.getMessage(), exception);
                }
                DataAccessObjectSession dataAccessObjectSession = jDBCDataAccessObjectOperator.startSession();
                RPC.registerSkeleton(dataAccessObjectSession);
                return dataAccessObjectSession;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                return (DataAccessObjectSession)RPC.getProxy(MessageDAOSession.class, string);
            }
        }
        try {
            this.dealCompatibility(jDBCDataAccessObjectOperator);
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage(), exception);
        }
        return jDBCDataAccessObjectOperator.startSession();
    }

    public void dealCompatibility(JDBCDataAccessObjectOperator jDBCDataAccessObjectOperator) throws Exception {
        jDBCDataAccessObjectOperator.checkTables();
    }

    @Override
    public FieldColumnMapper[] messageFieldColumnMapper() {
        return new FieldColumnMapper[]{new PrimaryKeyFCMapper("id", -5, new ColumnSize(10)), new CommonFieldColumnMapper("userId", -5, new ColumnSize(10), false), new CommonFieldColumnMapper("username", 12, new ColumnSize(128), false), new CommonFieldColumnMapper("message", 12, new ColumnSize(1024), false), new CommonFieldColumnMapper("toasted", 16, new ColumnSize(1), false), new CommonFieldColumnMapper("datetime", 91, new ColumnSize(10), false), new CommonFieldColumnMapper("createTime", 93, new ColumnSize(10), false), new CommonFieldColumnMapper("url", 12, new ColumnSize(512), false), new CommonFieldColumnMapper("readed", 16, new ColumnSize(1), false), new CommonFieldColumnMapper("type", 12, new ColumnSize(128), false)};
    }

    @Override
    public String[][] uniqueColumns() {
        return new String[][]{{"id"}};
    }

    public ObjectTableMapper getObjectTableMapper() {
        return new ObjectTableMapper(this.getDBClass(), this.getTable(), this.messageFieldColumnMapper(), 0);
    }

    @Override
    public MessageConverter converter() {
        return new DefaultMessageConverter();
    }
}

