/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.headerfooter;

import com.fr.base.GraphHelper;
import com.fr.base.headerfooter.AbstractHFPaintable;
import com.fr.base.headerfooter.HFElement;
import com.fr.base.headerfooter.TextHFElement;
import com.fr.general.FRFont;
import com.fr.stable.StringUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.StringTokenizer;

public class TextHFPaintable
extends AbstractHFPaintable {
    private TextHFElement textHFElement;

    public TextHFPaintable(TextHFElement textHFElement) {
        this.textHFElement = textHFElement;
    }

    public TextHFPaintable(Point2D point2D, TextHFElement textHFElement) {
        super(point2D);
        this.textHFElement = textHFElement;
    }

    public HFElement getHFElement() {
        return this.textHFElement;
    }

    public void paint(Graphics2D graphics2D, int n) {
        FRFont fRFont = this.textHFElement.getFRFont();
        Font font = fRFont.applyResolutionNP(n);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Font font2 = graphics2D.getFont();
        graphics2D.setPaint(fRFont.getForeground());
        graphics2D.setFont(font);
        String string = this.textHFElement.getText();
        StringTokenizer stringTokenizer = StringUtils.text2StringTokenizer(string);
        int n2 = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                string2 = "";
            }
            GraphHelper.drawString(graphics2D, string2, this.getPaintLocation().getX(), (double)n2 + this.getPaintLocation().getY() + (double)fontMetrics.getAscent());
            n2 += fontMetrics.getHeight();
        }
        graphics2D.setFont(font2);
    }
}

