/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.Inter;
import com.fr.stable.FormulaProvider;
import com.fr.stable.StableUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFCell;
import com.fr.third.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DateUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExcelUtils {
    public static final String XLS = "xls";
    public static final String XLSX = "xlsx";
    private static final char ASCII_NORMAL = ' ';
    private static final char ASCII_LATIN = '\u00a0';
    private static final double RATE = 0.75;
    private static final int N = 4;
    private static final int INCREASE_30 = 30;
    private static final int COL_WIDTH_20 = 20;
    private static final int COL_WIDTH_40 = 40;
    private static final int COL_WIDTH_50 = 50;
    private static final int COL_WIDTH_70 = 70;
    private static final Pattern PATTERN_$_COLUMNROW_1 = Pattern.compile("[\\$]{1}[a-zA-Z]+[\\$]?[1-9][0-9]*");
    private static final Pattern PATTERN_$_COLUMNROW_2 = Pattern.compile("[a-zA-Z]+[\\$]{1}[1-9][0-9]*");
    private static final Pattern PATTERN_$ = Pattern.compile("\\$");

    public static short printWidth2Design(short s) {
        if (s <= 0) {
            return 0;
        }
        s = (short)((double)s * 0.75);
        short s2 = (short)((s + 30) / 70 * 4);
        short s3 = (short)((s + 30) % 70);
        if (s3 < 0 || s3 >= 20) {
            if (s3 >= 20 && s3 < 40) {
                s2 = (short)(s2 + 1);
            } else if (s3 >= 40 && s3 <= 50) {
                s2 = (short)(s2 + 2);
            } else if (s3 > 50 && s3 < 70) {
                s2 = (short)(s2 + 3);
            }
        }
        return (short)(s - s2);
    }

    public static Object getHSSFCellValue(HSSFCell hSSFCell) {
        return ExcelUtils.getHSSFCellValue(hSSFCell, false);
    }

    public static Object getHSSFCellValueNoFormula(HSSFCell hSSFCell) {
        return ExcelUtils.getHSSFCellValue(hSSFCell, true);
    }

    private static Object getHSSFCellValue(HSSFCell hSSFCell, boolean bl) {
        if (hSSFCell == null) {
            return "";
        }
        Object object = null;
        if (hSSFCell.getCellType() == 1) {
            char[] cArray = hSSFCell.getRichStringCellValue().getString().toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] != '\u00a0') continue;
                cArray[i] = 32;
            }
            return String.valueOf(cArray);
        }
        if (hSSFCell.getCellType() == 0) {
            try {
                if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                    return hSSFCell.getDateCellValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(hSSFCell.getNumericCellValue()), true));
        } else if (hSSFCell.getCellType() == 4) {
            object = hSSFCell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
        } else if (hSSFCell.getCellType() == 2) {
            object = ExcelUtils.getCellFormulaValue(hSSFCell, bl);
        } else if (hSSFCell.getCellType() == 5) {
            object = "" + hSSFCell.getErrorCellValue();
        } else if (hSSFCell.getCellType() == 3) {
            object = "";
        }
        return object;
    }

    private static Object getExecutedFormulaValue(HSSFCell hSSFCell) {
        try {
            if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                return hSSFCell.getDateCellValue();
            }
            return StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(hSSFCell.getNumericCellValue()), true));
        }
        catch (Exception exception) {
            try {
                return hSSFCell.getStringCellValue();
            }
            catch (Exception exception2) {
                try {
                    return hSSFCell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Exception exception3) {
                    return ExcelUtils.getCellFormulaValue(hSSFCell, false);
                }
            }
        }
    }

    private static Object getCellFormulaValue(HSSFCell hSSFCell, boolean bl) {
        if (bl) {
            return ExcelUtils.getExecutedFormulaValue(hSSFCell);
        }
        Object object = null;
        try {
            String string = hSSFCell.getCellFormula();
            if (string != null) {
                if (string.trim().matches("^[\\=]+$")) {
                    object = string;
                } else {
                    string = ExcelUtils.resolveDColumnRowFString(string);
                    object = ExcelUtils.string2formula(string);
                }
            } else {
                object = ExcelUtils.string2formula(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static Object getCellValue(Cell cell) {
        return ExcelUtils.getCellValue(cell, false);
    }

    public static Object getCellValueNoFormula(Cell cell) {
        return ExcelUtils.getCellValue(cell, true);
    }

    public static Object getCellValue(Cell cell, boolean bl) {
        if (cell == null) {
            return "";
        }
        return ExcelUtils.getTypedCellValue(cell, bl, cell.getCellType());
    }

    private static Object getTypedCellValue(Cell cell, boolean bl, int n) {
        switch (n) {
            case 3: {
                return "";
            }
            case 4: {
                return ExcelUtils.getCellBooleanValue(cell);
            }
            case 5: {
                return ExcelUtils.getCellErrorValue(cell);
            }
            case 0: {
                return ExcelUtils.getCellDateValue(cell);
            }
            case 1: {
                return ExcelUtils.getCellStringValue(cell);
            }
            case 2: {
                return ExcelUtils.getCellFormulaValue(cell, bl);
            }
        }
        return "";
    }

    private static Object getCellBooleanValue(Cell cell) {
        return cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    private static Object getCellErrorValue(Cell cell) {
        return "" + cell.getErrorCellValue();
    }

    private static Object getCellDateValue(Cell cell) {
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            return cell.getDateCellValue();
        }
        return StableUtils.string2Number(StableUtils.convertNumberStringToString(new Double(cell.getNumericCellValue()), true));
    }

    private static Object getCellStringValue(Cell cell) {
        char[] cArray = cell.getRichStringCellValue().getString().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '\u00a0') continue;
            cArray[i] = 32;
        }
        return String.valueOf(cArray);
    }

    private static Object getCellFormulaValue(Cell cell, boolean bl) {
        if (bl) {
            return ExcelUtils.getTypedCellValue(cell, false, cell.getCachedFormulaResultType());
        }
        String string = cell.getCellFormula();
        if (string != null) {
            if (string.trim().matches("^[\\=]+$")) {
                return string;
            }
            string = ExcelUtils.resolveDColumnRowFString(string);
            return ExcelUtils.string2formula(string);
        }
        return ExcelUtils.string2formula(string);
    }

    private static FormulaProvider string2formula(String string) {
        FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
        formulaProvider.setContent(string);
        return formulaProvider;
    }

    private static String resolveDColumnRowFString(String string) {
        string = ExcelUtils.resolveDColumnRowFString(PATTERN_$_COLUMNROW_1, string);
        return ExcelUtils.resolveDColumnRowFString(PATTERN_$_COLUMNROW_2, string);
    }

    private static String resolveDColumnRowFString(Pattern pattern, String string) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            string2 = PATTERN_$.matcher(string2).replaceAll("");
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static boolean checkPOIJarExist() {
        return ExcelUtils.checkThirdJarSupportPOI();
    }

    public static void checkPOI() {
        if (!ExcelUtils.checkThirdJarSupportPOI()) {
            throw new RuntimeException(Inter.getLocText("FR-Engine-Excel_poi_2007"));
        }
    }

    public static boolean checkThirdJarSupportPOI() {
        try {
            Class.forName("com.fr.third.v2.org.apache.poi.VersionInfo");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void checkThirdJarPOI() {
        if (!ExcelUtils.checkThirdJarSupportPOI()) {
            throw new RuntimeException(Inter.getLocText("FR-Engine-Excel_poi_2007_third"));
        }
    }
}

