/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.ChartPreStyleManagerProvider;
import com.fr.base.Env;
import com.fr.base.FRContext;
import com.fr.cluster.rpc.RPC;
import com.fr.file.BaseClusterHelper;
import com.fr.file.XMLFileManager;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralContext;
import com.fr.general.Inter;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.stable.EnvChangedListener;
import com.fr.stable.ListMap;
import com.fr.stable.StringUtils;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLTools;
import com.fr.stable.xml.XMLWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class ChartPreStyleServerManager
extends XMLFileManager
implements XMLReadable,
XMLWriter,
ChartPreStyleManagerProvider {
    private static final String XML_TAG = "ChartPreStyleServerManager";
    private static ChartPreStyleManagerProvider styleManager = null;
    private ListMap preStyleMap = new ListMap();
    private String currentStyle = "";
    private Object styleEditing;
    private HashMap gisMapKeys = new HashMap(){
        {
            this.put("baiduKey", "");
            this.put("googleKey", "");
        }
    };
    private boolean gisType = true;

    public static synchronized ChartPreStyleServerManager getInstance() {
        return (ChartPreStyleServerManager)ChartPreStyleServerManager.getProviderInstance();
    }

    public static synchronized ChartPreStyleManagerProvider getProviderInstance() {
        if (styleManager == null) {
            ChartPreStyleServerManager.readChartPreStyle();
        }
        return styleManager;
    }

    public void putPreStyle(String string, Object object) {
        this.preStyleMap.put(string, object);
    }

    public void setCurrentStyle(String string) {
        this.currentStyle = string;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public void setStyleEditing(Object object) {
        this.styleEditing = object;
    }

    public Object getStyleEditing() {
        return this.styleEditing;
    }

    public Iterator names() {
        return this.preStyleMap.keySet().iterator();
    }

    public Object getPreStyle(Object object) {
        return this.preStyleMap.containsKey(object) ? this.preStyleMap.get(object) : null;
    }

    public boolean containsName(Object object) {
        return this.preStyleMap.containsKey(object);
    }

    public Object getDefaultPreStyle() {
        return this.getPreStyle(this.getCurrentStyle());
    }

    private static synchronized void envChanged() {
        styleManager = null;
    }

    private static void readChartPreStyle() {
        if (styleManager == null && ChartPreStyleServerManager.isClusterMember()) {
            return;
        }
        styleManager.clearPreStyles();
        styleManager.readXMLFile();
    }

    private static synchronized boolean isClusterMember() {
        switch (BaseClusterHelper.getClusterState()) {
            case LEADER: {
                styleManager = new ChartPreStyleServerManager();
                RPC.registerSkeleton(styleManager);
                return false;
            }
            case MEMBER: {
                String string = BaseClusterHelper.getMainServiceIP();
                styleManager = (ChartPreStyleManagerProvider)RPC.getProxy(ChartPreStyleServerManager.class, string);
                return true;
            }
        }
        styleManager = new ChartPreStyleServerManager();
        return false;
    }

    public void clearPreStyles() {
        this.preStyleMap.clear();
    }

    public String fileName() {
        return "chartPreStyle.xml";
    }

    public HashMap getGisMapKeys() {
        return this.gisMapKeys;
    }

    public String getBaiduKey() {
        if (this.gisMapKeys.containsKey("baiduKey")) {
            return (String)this.gisMapKeys.get("baiduKey");
        }
        return "";
    }

    public void setBaiduKey(String string) {
        if (this.gisMapKeys.containsKey("baiduKey")) {
            this.gisMapKeys.put("baiduKey", string);
        }
    }

    public String getGoogleKey() {
        if (this.gisMapKeys.containsKey("googleKey")) {
            return (String)this.gisMapKeys.get("googleKey");
        }
        return "";
    }

    public void setGoogleKey(String string) {
        if (this.gisMapKeys.containsKey("googleKey")) {
            this.gisMapKeys.put("googleKey", string);
        }
    }

    public String getBaiduSource() {
        String string = this.getBaiduKey();
        if (StringUtils.isBlank(string) || !this.gisType) {
            return "";
        }
        String string2 = "http://api.map.baidu.com/api?v=2.0&ak=" + string;
        string2 = "<script type=\"text/javascript\" src=\"" + string2 + "\"></script>";
        this.setBaiduKey("");
        return string2;
    }

    public String findBaiduSource() {
        return this.getBaiduSource();
    }

    public String findGoogleSource() {
        return this.getGoogleSource();
    }

    public String getGoogleSource() {
        String string = this.getGoogleKey();
        if (StringUtils.isBlank(string) || this.gisType) {
            return "";
        }
        String string2 = "http://maps.googleapis.com/maps/api/js?key=" + string + "&sensor=false";
        string2 = "<script type=\"text/javascript\" src=\"" + string2 + "\"></script>";
        this.setGoogleKey("");
        return string2;
    }

    public void setGisType(boolean bl) {
        this.gisType = bl;
    }

    public void writerPreChartStyle() {
        Env env = FRContext.getCurrentEnv();
        if (env == null) {
            return;
        }
        try {
            env.writeResource(styleManager);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(Inter.getLocText(new String[]{"Chart", "Style", "Failed"}));
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
    }

    public void readFromInputStream(InputStream inputStream) throws Exception {
        styleManager.clearPreStyles();
        XMLTools.readInputStreamXML(styleManager, inputStream);
        GeneralContext.getEnvProvider().writeResource(styleManager);
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (ComparatorUtils.equals("CPSattr", string)) {
                this.setCurrentStyle(xMLableReader.getAttrAsString("currentStyle", ""));
            } else if (ComparatorUtils.equals("OnePreStyle", string)) {
                final String string2 = xMLableReader.getAttrAsString("name", "");
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (ComparatorUtils.equals(xMLableReader.getTagName(), "OnePre")) {
                            XMLable xMLable = GeneralXMLTools.readXMLable(xMLableReader);
                            if (StringUtils.isNotEmpty(string2)) {
                                ChartPreStyleServerManager.this.putPreStyle(string2, xMLable);
                            }
                        }
                    }
                });
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG);
        xMLPrintWriter.startTAG("CPSattr").attr("currentStyle", this.getCurrentStyle()).end();
        if (!this.preStyleMap.isEmpty()) {
            for (Object e : this.preStyleMap.keySet()) {
                xMLPrintWriter.startTAG("OnePreStyle").attr("name", e.toString());
                GeneralXMLTools.writeXMLable(xMLPrintWriter, (XMLable)this.preStyleMap.get(e), "OnePre");
                xMLPrintWriter.end();
            }
        }
        xMLPrintWriter.end();
    }

    public boolean writeResource() throws Exception {
        return FRContext.getCurrentEnv().writeResource(ChartPreStyleServerManager.getProviderInstance());
    }

    public static void reinit() {
        ChartPreStyleServerManager.envChanged();
        ChartPreStyleServerManager.getProviderInstance();
    }

    static {
        GeneralContext.addEnvChangedListener(new EnvChangedListener(){

            public void envChanged() {
                ChartPreStyleServerManager.envChanged();
            }
        });
    }
}

