/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.canvas;

import com.mxgraph.canvas.mxICanvas2D;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLightweightLabel;
import com.mxgraph.util.mxUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;

public class mxGraphicsCanvas2D
implements mxICanvas2D {
    public static int IMAGE_SCALING = 4;
    public static int COLOR_CACHE_SIZE = 100;
    protected Graphics2D graphics;
    protected boolean autoAntiAlias = true;
    protected transient CanvasState state = new CanvasState();
    protected transient Stack<CanvasState> stack = new Stack();
    protected transient GeneralPath currentPath;
    protected transient boolean currentPathIsOrthogonal = true;
    protected transient Point2D lastPoint;
    protected transient Stroke currentStroke;
    protected transient Font currentFont;
    protected transient String currentShadowValue;
    protected transient Color currentShadowColor;
    protected CellRendererPane rendererPane;
    protected transient LinkedHashMap<String, Color> colorCache = new LinkedHashMap<String, Color>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Color> eldest) {
            return this.size() > COLOR_CACHE_SIZE;
        }
    };

    public mxGraphicsCanvas2D(Graphics2D g) {
        this.setGraphics(g);
        this.state.g = g;
        try {
            this.rendererPane = new CellRendererPane();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setGraphics(Graphics2D value) {
        this.graphics = value;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public boolean isAutoAntiAlias() {
        return this.autoAntiAlias;
    }

    public void setAutoAntiAlias(boolean value) {
        this.autoAntiAlias = value;
    }

    public void save() {
        this.stack.push(this.state);
        this.state = this.cloneState(this.state);
        this.state.g = (Graphics2D)this.state.g.create();
    }

    public void restore() {
        this.state = this.stack.pop();
        this.currentStroke = this.state.g.getStroke();
        this.currentFont = null;
    }

    protected CanvasState cloneState(CanvasState state) {
        try {
            return (CanvasState)state.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void scale(double value) {
        this.state.scale *= value;
        this.state.strokeWidth *= value;
    }

    public void translate(double dx, double dy) {
        this.state.dx += dx;
        this.state.dy += dy;
    }

    public void rotate(double theta, boolean flipH, boolean flipV, double cx, double cy) {
        cx *= this.state.scale;
        cy *= this.state.scale;
        cx += this.state.dx;
        cy += this.state.dy;
        if (flipH ^ flipV) {
            double tx = flipH ? cx : 0.0;
            int sx = flipH ? -1 : 1;
            double ty = flipV ? cy : 0.0;
            int sy = flipV ? -1 : 1;
            this.state.g.translate(tx, ty);
            this.state.g.scale(sx, sy);
            this.state.g.translate(-tx, -ty);
        }
        this.state.g.rotate(Math.toRadians(theta), cx, cy);
    }

    public void setStrokeWidth(double value) {
        if (value * this.state.scale != this.state.strokeWidth) {
            this.state.strokeWidth = value * this.state.scale;
            this.currentStroke = null;
        }
    }

    public void setStrokeColor(String value) {
        if (!this.state.strokeColorValue.equals(value)) {
            this.state.strokeColorValue = value;
            this.state.strokeColor = null;
        }
    }

    public void setDashed(boolean value) {
        if (value != this.state.dashed) {
            this.state.dashed = value;
            this.currentStroke = null;
        }
    }

    public void setDashPattern(String value) {
        if (value != null && !this.state.dashPattern.equals(value) && value.length() > 0) {
            String[] tokens = value.split(" ");
            float[] dashpattern = new float[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                dashpattern[i] = Float.parseFloat(tokens[i]);
            }
            this.state.dashPattern = dashpattern;
            this.currentStroke = null;
        }
    }

    public void setLineCap(String value) {
        if (!this.state.lineCap.equals(value)) {
            this.state.lineCap = value;
            this.currentStroke = null;
        }
    }

    public void setLineJoin(String value) {
        if (!this.state.lineJoin.equals(value)) {
            this.state.lineJoin = value;
            this.currentStroke = null;
        }
    }

    public void setMiterLimit(double value) {
        if (value != this.state.miterLimit) {
            this.state.miterLimit = value;
            this.currentStroke = null;
        }
    }

    public void setFontSize(double value) {
        if (value != this.state.fontSize) {
            this.state.fontSize = value * this.state.scale;
            this.currentFont = null;
        }
    }

    public void setFontColor(String value) {
        if (!this.state.fontColorValue.equals(value)) {
            this.state.fontColorValue = value;
            this.state.fontColor = null;
        }
    }

    public void setFontFamily(String value) {
        if (!this.state.fontFamily.equals(value)) {
            this.state.fontFamily = value;
            this.currentFont = null;
        }
    }

    public void setFontStyle(int value) {
        if (value != this.state.fontStyle) {
            this.state.fontStyle = value;
            this.currentFont = null;
        }
    }

    public void setAlpha(double value) {
        if (this.state.alpha != value) {
            this.state.g.setComposite(AlphaComposite.getInstance(3, (float)value));
            this.state.alpha = value;
        }
    }

    public void setFillColor(String value) {
        if (!this.state.fillColorValue.equals(value)) {
            this.state.fillColorValue = value;
            this.state.fillColor = null;
            this.state.paint = null;
        }
    }

    public void setGradient(String color1, String color2, double x, double y, double w, double h, String direction) {
        float x1 = (float)(this.state.dx + x * this.state.scale);
        float y1 = (float)(this.state.dy + y * this.state.scale);
        float x2 = x1;
        float y2 = y1;
        h *= this.state.scale;
        w *= this.state.scale;
        if (direction == null || direction.length() == 0 || direction.equals("south")) {
            y2 = (float)((double)y1 + h);
        } else if (direction.equals("east")) {
            x2 = (float)((double)x1 + w);
        } else if (direction.equals("north")) {
            y1 = (float)((double)y1 + h);
        } else if (direction.equals("west")) {
            x1 = (float)((double)x1 + w);
        }
        this.state.paint = new GradientPaint(x1, y1, this.parseColor(color1), x2, y2, this.parseColor(color2), true);
    }

    protected Color parseColor(String hex) {
        Color result = this.colorCache.get(hex);
        if (result == null) {
            result = mxUtils.parseColor(hex);
            this.colorCache.put(hex, result);
        }
        return result;
    }

    public void setGlassGradient(double x, double y, double w, double h) {
        double size = 0.4;
        x = this.state.dx + x * this.state.scale;
        y = this.state.dy + y * this.state.scale;
        w *= this.state.scale;
        this.state.paint = new GradientPaint((float)x, (float)y, new Color(1.0f, 1.0f, 1.0f, 0.9f), (float)x, (float)(y + (h *= this.state.scale) * size), new Color(1.0f, 1.0f, 1.0f, 0.3f));
    }

    public void rect(double x, double y, double w, double h) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Rectangle2D.Double(this.state.dx + x * this.state.scale, this.state.dy + y * this.state.scale, w * this.state.scale, h * this.state.scale), false);
    }

    public void roundrect(double x, double y, double w, double h, double dx, double dy) {
        this.begin();
        this.moveTo(x + dx, y);
        this.lineTo(x + w - dx, y);
        this.quadTo(x + w, y, x + w, y + dy);
        this.lineTo(x + w, y + h - dy);
        this.quadTo(x + w, y + h, x + w - dx, y + h);
        this.lineTo(x + dx, y + h);
        this.quadTo(x, y + h, x, y + h - dy);
        this.lineTo(x, y + dy);
        this.quadTo(x, y, x + dx, y);
    }

    public void ellipse(double x, double y, double w, double h) {
        this.currentPath = new GeneralPath();
        this.currentPath.append(new Ellipse2D.Double(this.state.dx + x * this.state.scale, this.state.dy + y * this.state.scale, w * this.state.scale, h * this.state.scale), false);
        this.currentPathIsOrthogonal = false;
    }

    public void image(double x, double y, double w, double h, String src, boolean aspect, boolean flipH, boolean flipV) {
        Image img;
        if (src != null && w > 0.0 && h > 0.0 && (img = this.loadImage(src)) != null) {
            Rectangle bounds = this.getImageBounds(img, x, y, w, h, aspect);
            if ((img = this.scaleImage(img, bounds.width, bounds.height)) != null) {
                this.drawImage(this.createImageGraphics(bounds.x, bounds.y, bounds.width, bounds.height, flipH, flipV), img, bounds.x, bounds.y);
            }
        }
    }

    protected void drawImage(Graphics2D graphics, Image image, int x, int y) {
        graphics.drawImage(image, x, y, null);
    }

    protected Image loadImage(String src) {
        return mxUtils.loadImage(src);
    }

    protected final Rectangle getImageBounds(Image img, double x, double y, double w, double h, boolean aspect) {
        x = this.state.dx + x * this.state.scale;
        y = this.state.dy + y * this.state.scale;
        w *= this.state.scale;
        h *= this.state.scale;
        if (aspect) {
            Dimension size = this.getImageSize(img);
            double s = Math.min(w / (double)size.width, h / (double)size.height);
            int sw = (int)Math.round((double)size.width * s);
            int sh = (int)Math.round((double)size.height * s);
            x += (w - (double)sw) / 2.0;
            y += (h - (double)sh) / 2.0;
            w = sw;
            h = sh;
        } else {
            w = Math.round(w);
            h = Math.round(h);
        }
        return new Rectangle((int)x, (int)y, (int)w, (int)h);
    }

    protected Dimension getImageSize(Image image) {
        return new Dimension(image.getWidth(null), image.getHeight(null));
    }

    protected Image scaleImage(Image img, int w, int h) {
        Dimension size = this.getImageSize(img);
        if (w == size.width && h == size.height) {
            return img;
        }
        return img.getScaledInstance(w, h, IMAGE_SCALING);
    }

    protected final Graphics2D createImageGraphics(double x, double y, double w, double h, boolean flipH, boolean flipV) {
        Graphics2D g2 = this.state.g;
        if (flipH || flipV) {
            g2 = (Graphics2D)g2.create();
            int sx = 1;
            int sy = 1;
            int dx = 0;
            int dy = 0;
            if (flipH) {
                sx = -1;
                dx = (int)(-w - 2.0 * x);
            }
            if (flipV) {
                sy = -1;
                dy = (int)(-h - 2.0 * y);
            }
            g2.scale(sx, sy);
            g2.translate(dx, dy);
        }
        return g2;
    }

    protected String createHtmlDocument(String text, String align, String valign, int w, int h) {
        StringBuffer css = new StringBuffer();
        css.append("font-family:" + this.state.fontFamily + ";");
        css.append("font-size:" + Math.floor(this.state.fontSize / this.state.scale) + " pt;");
        css.append("color:" + this.state.fontColorValue + ";");
        if ((this.state.fontStyle & 1) == 1) {
            css.append("font-weight:bold;");
        }
        if ((this.state.fontStyle & 2) == 2) {
            css.append("font-style:italic;");
        }
        if ((this.state.fontStyle & 4) == 4) {
            css.append("text-decoration:underline;");
        }
        if (align != null) {
            if (align.equals("center")) {
                css.append("text-align:center;");
            } else if (align.equals("right")) {
                css.append("text-align:right;");
            }
        }
        return "<html><div style=\"width:" + w + "px;height:" + h + "px;" + css.toString() + "\">" + text + "</div></html>";
    }

    protected JLabel getTextRenderer() {
        return mxLightweightLabel.getSharedInstance();
    }

    public void text(double x, double y, double w, double h, String str, String align, String valign, boolean vertical, boolean wrap, String format) {
        if (!this.state.fontColorValue.equals(mxConstants.NONE)) {
            if (format != null && format.equals("html")) {
                x += this.state.dx / this.state.scale;
                y += this.state.dy / this.state.scale;
                JLabel textRenderer = this.getTextRenderer();
                if (textRenderer != null && this.rendererPane != null) {
                    AffineTransform previous = this.state.g.getTransform();
                    this.state.g.scale(this.state.scale, this.state.scale);
                    str = this.createHtmlDocument(str, align, valign, (int)Math.round(w * mxConstants.PX_PER_PIXEL), (int)Math.round(h * mxConstants.PX_PER_PIXEL));
                    textRenderer.setText(str);
                    this.rendererPane.paintComponent(this.state.g, textRenderer, this.rendererPane, (int)Math.round(x), (int)Math.round(y), (int)Math.round(w), (int)Math.round(h), true);
                    this.state.g.setTransform(previous);
                }
            } else {
                x = this.state.dx + x * this.state.scale;
                y = this.state.dy + y * this.state.scale;
                Graphics2D g2 = this.createTextGraphics(x, y, w *= this.state.scale, h *= this.state.scale, vertical);
                FontMetrics fm = g2.getFontMetrics();
                String[] lines = str.split("\n");
                y = this.getVerticalTextPosition(x, y, w, h, align, valign, vertical, fm, lines);
                x = this.getHorizontalTextPosition(x, y, w, h, align, valign, vertical, fm, lines);
                for (int i = 0; i < lines.length; ++i) {
                    double dx = 0.0;
                    if (align != null) {
                        if (align.equals("center")) {
                            int sw = fm.stringWidth(lines[i]);
                            dx = (w - (double)sw) / 2.0;
                        } else if (align.equals("right")) {
                            int sw = fm.stringWidth(lines[i]);
                            dx = w - (double)sw;
                        }
                    }
                    if ((this.state.fontStyle & 4) == 4) {
                        AttributedString as = new AttributedString(lines[i]);
                        as.addAttribute(TextAttribute.FONT, g2.getFont());
                        as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                        g2.drawString(as.getIterator(), (int)Math.round(x + dx), (int)Math.round(y));
                    } else {
                        g2.drawString(lines[i], (int)Math.round(x + dx), (int)Math.round(y));
                    }
                    y += (double)(fm.getHeight() + mxConstants.LINESPACING);
                }
            }
        }
    }

    protected final Graphics2D createTextGraphics(double x, double y, double w, double h, boolean vertical) {
        Graphics2D g2 = this.state.g;
        this.updateFont();
        if (vertical) {
            g2 = (Graphics2D)this.state.g.create();
            g2.rotate(-1.5707963267948966, x + w / 2.0, y + h / 2.0);
        }
        if (this.state.fontColor == null) {
            this.state.fontColor = this.parseColor(this.state.fontColorValue);
        }
        g2.setColor(this.state.fontColor);
        return g2;
    }

    protected double getVerticalTextPosition(double x, double y, double w, double h, String align, String valign, boolean vertical, FontMetrics fm, String[] lines) {
        double lineHeight = fm.getHeight() + mxConstants.LINESPACING;
        double textHeight = (double)lines.length * lineHeight;
        double dy = h - textHeight;
        if (valign == null || valign.equals("top")) {
            y = Math.max(y - 2.0 * this.state.scale, y + dy / 2.0);
        } else if (valign.equals("middle")) {
            y += dy / 2.0;
        } else if (valign.equals("bottom")) {
            y = Math.min(y, y + dy);
        }
        return y + (double)fm.getHeight() * 0.75;
    }

    protected double getHorizontalTextPosition(double x, double y, double w, double h, String align, String valign, boolean vertical, FontMetrics fm, String[] lines) {
        if (align == null || align.equals("left")) {
            x += 2.0 * this.state.scale;
        }
        return x;
    }

    public void begin() {
        this.currentPath = new GeneralPath();
        this.currentPathIsOrthogonal = true;
        this.lastPoint = null;
    }

    public void moveTo(double x, double y) {
        if (this.currentPath != null) {
            this.currentPath.moveTo((float)(this.state.dx + x * this.state.scale), (float)(this.state.dy + y * this.state.scale));
            if (this.isAutoAntiAlias()) {
                this.lastPoint = new Point2D.Double(x, y);
            }
        }
    }

    public void lineTo(double x, double y) {
        if (this.currentPath != null) {
            this.currentPath.lineTo((float)(this.state.dx + x * this.state.scale), (float)(this.state.dy + y * this.state.scale));
            if (this.isAutoAntiAlias()) {
                if (this.lastPoint != null && this.currentPathIsOrthogonal && x != this.lastPoint.getX() && y != this.lastPoint.getY()) {
                    this.currentPathIsOrthogonal = false;
                }
                this.lastPoint = new Point2D.Double(x, y);
            }
        }
    }

    public void quadTo(double x1, double y1, double x2, double y2) {
        if (this.currentPath != null) {
            this.currentPath.quadTo((float)(this.state.dx + x1 * this.state.scale), (float)(this.state.dy + y1 * this.state.scale), (float)(this.state.dx + x2 * this.state.scale), (float)(this.state.dy + y2 * this.state.scale));
            this.currentPathIsOrthogonal = false;
        }
    }

    public void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        if (this.currentPath != null) {
            this.currentPath.curveTo((float)(this.state.dx + x1 * this.state.scale), (float)(this.state.dy + y1 * this.state.scale), (float)(this.state.dx + x2 * this.state.scale), (float)(this.state.dy + y2 * this.state.scale), (float)(this.state.dx + x3 * this.state.scale), (float)(this.state.dy + y3 * this.state.scale));
            this.currentPathIsOrthogonal = false;
        }
    }

    public void close() {
        if (this.currentPath != null) {
            this.currentPath.closePath();
        }
    }

    public void stroke() {
        if (this.currentPath != null && !this.state.strokeColorValue.equals(mxConstants.NONE)) {
            if (this.state.strokeColor == null) {
                this.state.strokeColor = this.parseColor(this.state.strokeColorValue);
            }
            this.updateStroke();
            this.state.g.setColor(this.state.strokeColor);
            Object previousHint = null;
            if (this.isAutoAntiAlias() && this.currentPathIsOrthogonal) {
                previousHint = this.state.g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                this.state.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            this.state.g.draw(this.currentPath);
            if (previousHint != null) {
                this.state.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, previousHint);
            }
        }
    }

    public void fill() {
        if (!(this.currentPath == null || this.state.fillColorValue.equals(mxConstants.NONE) && this.state.paint == null)) {
            if (this.state.paint != null) {
                this.state.g.setPaint(this.state.paint);
            } else {
                if (this.state.fillColor == null) {
                    this.state.fillColor = this.parseColor(this.state.fillColorValue);
                }
                this.state.g.setColor(this.state.fillColor);
                this.state.g.setPaint(null);
            }
            this.state.g.fill(this.currentPath);
        }
    }

    public void fillAndStroke() {
        this.fill();
        this.stroke();
    }

    public void shadow(String value, boolean filled) {
        if (value != null && this.currentPath != null) {
            if (this.currentShadowColor == null || this.currentShadowValue == null || !this.currentShadowValue.equals(value)) {
                this.currentShadowColor = this.parseColor(value);
                this.currentShadowValue = value;
            }
            this.updateStroke();
            this.state.g.setColor(this.currentShadowColor);
            if (filled) {
                this.state.g.fill(this.currentPath);
            }
            this.state.g.draw(this.currentPath);
        }
    }

    public void clip() {
        if (this.currentPath != null) {
            this.state.g.clip(this.currentPath);
        }
    }

    protected void updateFont() {
        if (this.currentFont == null) {
            int size = (int)Math.floor(this.state.fontSize);
            int style = (this.state.fontStyle & 1) == 1 ? 1 : 0;
            this.currentFont = this.createFont(this.state.fontFamily, style += (this.state.fontStyle & 2) == 2 ? 2 : 0, size);
            this.state.g.setFont(this.currentFont);
        }
    }

    protected Font createFont(String family, int style, int size) {
        return new Font(this.getFontName(family), style, size);
    }

    protected String getFontName(String family) {
        int comma;
        if (family != null && (comma = family.indexOf(44)) >= 0) {
            family = family.substring(0, comma);
        }
        return family;
    }

    protected void updateStroke() {
        if (this.currentStroke == null) {
            int cap = 0;
            if (this.state.lineCap.equals("round")) {
                cap = 1;
            } else if (this.state.lineCap.equals("square")) {
                cap = 2;
            }
            int join = 0;
            if (this.state.lineJoin.equals("round")) {
                join = 1;
            } else if (this.state.lineJoin.equals("bevel")) {
                join = 2;
            }
            float miterlimit = (float)this.state.miterLimit;
            float[] dash = null;
            if (this.state.dashed) {
                dash = new float[this.state.dashPattern.length];
                for (int i = 0; i < dash.length; ++i) {
                    dash[i] = (float)((double)this.state.dashPattern[i] * this.state.strokeWidth);
                }
            }
            this.currentStroke = new BasicStroke((float)this.state.strokeWidth, cap, join, miterlimit, dash, 0.0f);
            this.state.g.setStroke(this.currentStroke);
        }
    }

    protected class CanvasState
    implements Cloneable {
        protected double alpha = 1.0;
        protected double scale = 1.0;
        protected double dx = 0.0;
        protected double dy = 0.0;
        protected double miterLimit = 10.0;
        protected int fontStyle = 0;
        protected double fontSize = mxConstants.DEFAULT_FONTSIZE;
        protected String fontFamily = mxConstants.DEFAULT_FONTFAMILIES;
        protected String fontColorValue = "#000000";
        protected Color fontColor;
        protected String lineCap = "flat";
        protected String lineJoin = "miter";
        protected double strokeWidth = 1.0;
        protected String strokeColorValue = mxConstants.NONE;
        protected Color strokeColor;
        protected String fillColorValue = mxConstants.NONE;
        protected Color fillColor;
        protected Paint paint;
        protected boolean dashed = false;
        protected float[] dashPattern = new float[]{3.0f, 3.0f};
        protected transient Graphics2D g;

        protected CanvasState() {
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

