/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.service;

import com.fr.data.NetworkHelper;
import com.fr.general.ComparatorUtils;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.PrivilegeManagerProvider;
import com.fr.privilege.filter.core.PrivilegeVoteImpls;
import com.fr.stable.StringUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PerformanceAuthorityManager {
    private static PerformanceAuthorityManager ourInstance = new PerformanceAuthorityManager();

    public static PerformanceAuthorityManager getInstance() {
        return ourInstance;
    }

    private PerformanceAuthorityManager() {
    }

    boolean checkAuthority(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (!this.hasFSAuth(httpServletRequest)) {
            this.writeLoginHtml(httpServletRequest, httpServletResponse);
            return false;
        }
        if (!this.isRoot(httpServletRequest)) {
            this.writeNoAuth(httpServletRequest, httpServletResponse);
            return false;
        }
        return true;
    }

    private void writeLoginHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrivilegeVoteImpls.MP_AUTH_ERROR.action(httpServletRequest, httpServletResponse);
    }

    private void writeNoAuth(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrivilegeVoteImpls.MP_ROLE_ERROR.action(httpServletRequest, httpServletResponse);
    }

    boolean isRoot(HttpServletRequest httpServletRequest) {
        PrivilegeManagerProvider privilegeManagerProvider = PrivilegeManager.getProviderInstance();
        String string = NetworkHelper.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"fr_username");
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return ComparatorUtils.equals((String)string, (String)privilegeManagerProvider.getRootManagerName());
    }

    boolean hasFSAuth(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession();
        return httpSession.getAttribute("fr_fs_auth_key") != null;
    }
}

