/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.service;

import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.performance.dao.FileManager;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetOverMemoryInfoListAction
extends ActionNoSessionCMD {
    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        File file = new File(FileManager.getOverMemoryDir());
        JSONArray jSONArray = new JSONArray();
        if (file.exists()) {
            String[] stringArray = GetOverMemoryInfoListAction.getValidFile(file);
            this.sort(stringArray);
            for (String string2 : stringArray) {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("name", (Object)string2);
                jSONArray.put((Object)jSONObject);
            }
        }
        WebUtils.printAsJSON((HttpServletResponse)httpServletResponse, (JSONArray)jSONArray);
    }

    private void sort(String[] stringArray) {
        Arrays.sort(stringArray, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return -string.compareTo(string2);
            }
        });
    }

    private static String[] getValidFile(File file) {
        return file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith("over_memory") && string.endsWith(".info");
            }
        });
    }

    public String getCMD() {
        return "over_memory_list";
    }

    public static void main(String[] stringArray) {
        File file = new File("D:\\fineReport\\WebReport\\WEB-INF\\performance\\memory");
        if (file.exists()) {
            String[] stringArray2;
            for (String string : stringArray2 = GetOverMemoryInfoListAction.getValidFile(file)) {
                System.out.println(string);
            }
        }
    }
}

