/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.performance.exception.OverThresholdMemoryException;
import com.fr.performance.memory.ConfigBean;
import com.fr.performance.memory.MemoryConfig;
import com.fr.performance.memory.MemoryManager;
import com.fr.performance.memory.MemoryMonitor;
import java.lang.management.MemoryPoolMXBean;
import java.util.LinkedList;
import junit.framework.TestCase;

public class MemoryTest
extends TestCase {
    private int max = 200;

    public void testGetTenuredMemoryUsage() {
        MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
        MemoryTest.assertNotNull((Object)memoryPoolMXBean);
    }

    public void _testCheckMemory() {
        this.setConfigBean(0x100000, 0);
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            for (int i = 0; i < 1000; ++i) {
                linkedList.add(new Object());
                if ((i & 0xFF) != 0) continue;
                System.gc();
                MemoryMonitor.checkMemory();
            }
        }
        catch (OverThresholdMemoryException overThresholdMemoryException) {
            return;
        }
        MemoryTest.fail((String)"should over threshold memory");
    }

    public void testCalculateThreshold() {
        this.assertCalculateThreshold(0, 80, 160);
        this.assertCalculateThreshold(0, 120, 200);
        this.assertCalculateThreshold(120, 80, 120);
        this.assertCalculateThreshold(220, 80, 200);
        this.assertCalculateThreshold(-1, 80, 160);
        this.assertCalculateThreshold(-1, -2, 0);
    }

    private void assertCalculateThreshold(int n, int n2, int n3) {
        this.setConfigBean(n, n2);
        MemoryTest.assertEquals((long)n3, (long)MemoryConfig.calculateThreshold(this.max));
    }

    private void setConfigBean(int n, int n2) {
        ConfigBean configBean = new ConfigBean();
        configBean.setUseThreshold(n);
        configBean.setUseThresholdPercent(n2);
        MemoryConfig.setConfigBean(configBean);
        MemoryConfig.refresh();
    }
}

