/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.memory;

import com.fr.performance.exception.OverThresholdMemoryException;
import com.fr.performance.memory.MemoryConfig;
import com.fr.performance.memory.MemoryManager;
import com.fr.performance.strategy.Strategy;
import com.fr.performance.strategy.StrategyManager;
import java.lang.management.MemoryPoolMXBean;

public class MemoryMonitor {
    private static boolean isOnMonitor = true;
    private static final long UNCHECKED_MEMORY = 0x100000L;
    private static final int MAX_UNCHECKED_COUNT = 100;
    private static int uncheckedCount;
    private static final double maxPercent = 0.625;

    public static void init() {
        MemoryConfig.init();
    }

    public static void setMonitorEnable(boolean bl) {
        isOnMonitor = bl;
    }

    private static boolean isOnMonitor() {
        return isOnMonitor;
    }

    public static void checkMemoryAfterAllocated(long l) {
        if (MemoryMonitor.isIgnoreCheck(l)) {
            return;
        }
        MemoryMonitor.checkMemory();
    }

    public static void checkMemory() throws OverThresholdMemoryException {
        MemoryMonitor.checkMemory(StrategyManager.getOverMemoryStrategy());
    }

    public static void checkMemory(Strategy strategy) {
        if (MemoryMonitor.isOnMonitor() && MemoryMonitor.isOverThreshold()) {
            strategy.action();
        }
    }

    public static void checkMemoryBeforeAllocated(long l) {
        if (MemoryMonitor.isIgnoreCheck(l)) {
            return;
        }
        if (MemoryMonitor.isOnMonitor() && MemoryMonitor.isOverThresholdWhenAllocate(l)) {
            StrategyManager.getOverMemoryStrategy().action();
        }
    }

    private static boolean isIgnoreCheck(long l) {
        if (l < 0x100000L || uncheckedCount < 100) {
            ++uncheckedCount;
            return true;
        }
        uncheckedCount = 0;
        return false;
    }

    static boolean isOverThreshold() {
        MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
        if (MemoryManager.checkValid(memoryPoolMXBean)) {
            return memoryPoolMXBean.isUsageThresholdExceeded();
        }
        return MemoryMonitor.isOverThresholdWhenAllocate(0L);
    }

    static boolean isOverThresholdWhenAllocate(long l) {
        MemoryPoolMXBean memoryPoolMXBean = MemoryManager.getTenuredMemoryPool();
        if (memoryPoolMXBean == null) {
            return MemoryMonitor.isOverThresholdWhenNoMXBean();
        }
        return MemoryMonitor.isOverThreshold(memoryPoolMXBean, l);
    }

    private static boolean isOverThreshold(MemoryPoolMXBean memoryPoolMXBean, long l) {
        long l2;
        long l3 = memoryPoolMXBean.getUsage().getUsed();
        long l4 = l3 + l;
        return l4 >= MemoryConfig.calculateThreshold(l2 = memoryPoolMXBean.getUsage().getMax());
    }

    private static boolean isOverThresholdWhenNoMXBean() {
        double d = 0.625;
        long l = (long)((double)Runtime.getRuntime().maxMemory() * d);
        long l2 = MemoryConfig.calculateThreshold(l);
        long l3 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (l3 > l) {
            return true;
        }
        return (double)l3 - (1.0 - d) / 2.0 * (double)l > (double)l2;
    }

    private static long estimateUsedMemoryWhenNoMXBean() {
        long l = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return l;
    }

    static {
        MemoryMonitor.init();
    }
}

