/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.general.FRLogger;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.InfoSaver;
import com.fr.performance.dao.JSONInfoSaver;
import com.fr.performance.dao.QueueInfoSaver;
import com.fr.performance.utils.SessionIDInfoUtils;
import com.fr.stable.monitor.MemoryHelper;
import java.util.logging.Level;

public class MemorySaverManager {
    private static long lastSaveTime;
    private static int ignoreCount;
    private static final long MIN_INTERVAL = 100000L;
    private static final int MAX_IGNORE_COUNT = 100;

    public static void saveOverMemoryInfo() {
        if (MemorySaverManager.isIgnore()) {
            return;
        }
        lastSaveTime = System.currentTimeMillis();
        MemorySaverManager.saveOverMemoryInfo0();
    }

    private static boolean isIgnore() {
        return System.currentTimeMillis() - lastSaveTime < 100000L;
    }

    private static void saveOverMemoryInfo0() {
        FRLogger.getLogger().log(Level.WARNING, "Memory is over threshold!");
        InfoSaver infoSaver = MemorySaverManager.createSaverInfo();
        infoSaver.save(SessionIDInfoUtils.getCurrentReportInfo());
        MemoryHelper.getMemoryAlarmProcessor().interruptIfConditionMet(new Object[0]);
    }

    private static InfoSaver createSaverInfo() {
        return new QueueInfoSaver(JSONInfoSaver.create(FileManager.createOverMemoryFile()));
    }
}

