/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.general.FRLogger;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.InfoReader;
import com.fr.performance.dao.JSONInfoReader;
import com.fr.performance.info.CurrentReportArrayInfo;
import com.fr.performance.info.InfoCreator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryReaderManager {
    public static CurrentReportArrayInfo readOverMemoryInfo(String string) {
        InfoReader<CurrentReportArrayInfo> infoReader = MemoryReaderManager.createJSONInfoReader(string);
        CurrentReportArrayInfo currentReportArrayInfo = infoReader.read();
        infoReader.close();
        return currentReportArrayInfo;
    }

    private static InfoReader<CurrentReportArrayInfo> createJSONInfoReader(String string) {
        JSONInfoReader<CurrentReportArrayInfo> jSONInfoReader = new JSONInfoReader<CurrentReportArrayInfo>();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(FileManager.getOverMemoryFile(string)));
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage(), (Throwable)iOException);
        }
        jSONInfoReader.setInputStream(bufferedInputStream);
        jSONInfoReader.setInfoCreator(InfoCreator.CURRENT_INFO_CREATOR);
        return jSONInfoReader;
    }
}

