/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.openwebflow.util.ModelUtils;
import org.openwebflow.util.ProcessDefinitionUtils;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessEngineTool {
    @Autowired
    private ProcessEngine _processEngine;

    public Model createNewModel(String name, String description) throws IOException {
        return ModelUtils.createNewModel(this._processEngine.getRepositoryService(), name, description);
    }

    public Deployment deployModel(String modelId) throws IOException {
        return ModelUtils.deployModel(this._processEngine.getRepositoryService(), modelId);
    }

    public ActivityImpl getActivity(String processDefId, String activityId) {
        return ProcessDefinitionUtils.getActivity(this._processEngine, processDefId, activityId);
    }

    public Map<String, Object> getHistoricProcessVariables(String processId) {
        List list = this._processEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(processId).list();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (HistoricVariableInstance var : list) {
            vars.put(var.getVariableName(), var.getValue());
        }
        return vars;
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefId) {
        return ProcessDefinitionUtils.getProcessDefinition(this._processEngine, processDefId);
    }

    public ProcessEngine getProcessEngine() {
        return this._processEngine;
    }

    public void grantPermission(ActivityImpl activity, String assigneeExpression, String candidateGroupIdExpressions, String candidateUserIdExpressions) throws Exception {
        ProcessDefinitionUtils.grantPermission(activity, assigneeExpression, candidateGroupIdExpressions, candidateUserIdExpressions);
    }

    public void grantPermission(String processDefId, String activityId, String assigneeExpression, String candidateGroupIdExpressions, String candidateUserIdExpressions) throws Exception {
        ProcessDefinitionUtils.grantPermission(ProcessDefinitionUtils.getActivity(this._processEngine, processDefId, activityId), assigneeExpression, candidateGroupIdExpressions, candidateUserIdExpressions);
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this._processEngine = processEngine;
    }
}

