/*
 * Decompiled with CFR 0.152.
 */
package org.openwebflow.ctrl.creator;

import java.util.List;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.openwebflow.ctrl.RuntimeActivityDefinitionEntity;
import org.openwebflow.ctrl.creator.RuntimeActivityCreator;
import org.openwebflow.ctrl.creator.RuntimeActivityCreatorSupport;
import org.openwebflow.ctrl.creator.RuntimeActivityDefinitionEntityIntepreter;
import org.openwebflow.util.ProcessDefinitionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInstanceActivityCreator
extends RuntimeActivityCreatorSupport
implements RuntimeActivityCreator {
    @Override
    public ActivityImpl[] createActivities(ProcessEngine processEngine, ProcessDefinitionEntity processDefinition, RuntimeActivityDefinitionEntity info) {
        info.setFactoryName(MultiInstanceActivityCreator.class.getName());
        RuntimeActivityDefinitionEntityIntepreter radei = new RuntimeActivityDefinitionEntityIntepreter(info);
        if (radei.getCloneActivityId() == null) {
            String cloneActivityId = this.createUniqueActivityId(info.getProcessInstanceId(), radei.getPrototypeActivityId());
            radei.setCloneActivityId(cloneActivityId);
        }
        return new ActivityImpl[]{this.createMultiInstanceActivity(processEngine, processDefinition, info.getProcessInstanceId(), radei.getPrototypeActivityId(), radei.getCloneActivityId(), radei.getSequential(), radei.getAssignees())};
    }

    private ActivityImpl createMultiInstanceActivity(ProcessEngine processEngine, ProcessDefinitionEntity processDefinition, String processInstanceId, String prototypeActivityId, String cloneActivityId, boolean isSequential, List<String> assignees) {
        ActivityImpl prototypeActivity = ProcessDefinitionUtils.getActivity(processEngine, processDefinition.getId(), prototypeActivityId);
        ActivityImpl clone = this.cloneActivity(processDefinition, prototypeActivity, cloneActivityId, "executionListeners", "properties");
        for (PvmTransition trans : prototypeActivity.getOutgoingTransitions()) {
            clone.createOutgoingTransition(trans.getId()).setDestination((ActivityImpl)trans.getDestination());
        }
        SequentialMultiInstanceBehavior multiInstanceBehavior = isSequential ? new SequentialMultiInstanceBehavior(clone, (AbstractBpmnActivityBehavior)((TaskActivityBehavior)prototypeActivity.getActivityBehavior())) : new ParallelMultiInstanceBehavior(clone, (AbstractBpmnActivityBehavior)((TaskActivityBehavior)prototypeActivity.getActivityBehavior()));
        clone.setActivityBehavior((ActivityBehavior)multiInstanceBehavior);
        clone.setScope(true);
        clone.setProperty("multiInstance", (Object)(isSequential ? "sequential" : "parallel"));
        multiInstanceBehavior.setLoopCardinalityExpression((Expression)new FixedValue((Object)assignees.size()));
        multiInstanceBehavior.setCollectionExpression((Expression)new FixedValue(assignees));
        return clone;
    }
}

