/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.util.Iterator;
import java.util.Vector;
import javax.xml.soap.MimeHeader;

public class MimeHeaders {
    private Vector headers = new Vector();

    public String[] getHeader(String string2) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(i);
            if (!mimeHeader.getName().equalsIgnoreCase(string2) || mimeHeader.getValue() == null) continue;
            vector.addElement(mimeHeader.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setHeader(String string2, String string3) {
        boolean bl = false;
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(i);
            if (!mimeHeader.getName().equalsIgnoreCase(string2)) continue;
            if (!bl) {
                this.headers.setElementAt(new MimeHeader(mimeHeader.getName(), string3), i);
                bl = true;
                continue;
            }
            this.headers.removeElementAt(i--);
        }
        if (!bl) {
            this.addHeader(string2, string3);
        }
    }

    public void addHeader(String string2, String string3) {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Illegal MimeHeader name");
        }
        int n = this.headers.size();
        for (int i = n - 1; i >= 0; --i) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(i);
            if (!mimeHeader.getName().equalsIgnoreCase(string2)) continue;
            this.headers.insertElementAt(new MimeHeader(string2, string3), i + 1);
            return;
        }
        this.headers.addElement(new MimeHeader(string2, string3));
    }

    public void removeHeader(String string2) {
        for (int i = 0; i < this.headers.size(); ++i) {
            MimeHeader mimeHeader = (MimeHeader)this.headers.elementAt(i);
            if (!mimeHeader.getName().equalsIgnoreCase(string2)) continue;
            this.headers.removeElementAt(i--);
        }
    }

    public void removeAllHeaders() {
        this.headers.removeAllElements();
    }

    public Iterator getAllHeaders() {
        return this.headers.iterator();
    }

    public Iterator getMatchingHeaders(String[] stringArray) {
        return new MatchingIterator(stringArray, true);
    }

    public Iterator getNonMatchingHeaders(String[] stringArray) {
        return new MatchingIterator(stringArray, false);
    }

    class MatchingIterator
    implements Iterator {
        private boolean match;
        private Iterator iterator;
        private String[] names;
        private Object nextHeader;

        MatchingIterator(String[] stringArray, boolean bl) {
            this.match = bl;
            this.names = stringArray;
            this.iterator = MimeHeaders.this.headers.iterator();
        }

        private Object nextMatch() {
            block0: while (this.iterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)this.iterator.next();
                if (this.names == null) {
                    return this.match ? null : mimeHeader;
                }
                for (int i = 0; i < this.names.length; ++i) {
                    if (!mimeHeader.getName().equalsIgnoreCase(this.names[i])) continue;
                    if (!this.match) continue block0;
                    return mimeHeader;
                }
                if (this.match) continue;
                return mimeHeader;
            }
            return null;
        }

        public boolean hasNext() {
            if (this.nextHeader == null) {
                this.nextHeader = this.nextMatch();
            }
            return this.nextHeader != null;
        }

        public Object next() {
            if (this.nextHeader != null) {
                Object object = this.nextHeader;
                this.nextHeader = null;
                return object;
            }
            if (this.hasNext()) {
                return this.nextHeader;
            }
            return null;
        }

        public void remove() {
            this.iterator.remove();
        }
    }
}

