/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.wsit;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelCreator;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelWSImpl;
import com.sun.xml.ws.transport.tcp.util.ConnectionManagementSettings;
import com.sun.xml.ws.transport.tcp.wsit.TCPConstants;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class PolicyConnectionManagementSettingsHolder
implements ConnectionManagementSettings.ConnectionManagementSettingsHolder {
    private static final int DEFAULT_VALUE = -1;
    private static final Logger logger = Logger.getLogger("com.sun.xml.ws.transport.tcp");
    volatile ConnectionManagementSettings clientSettings;
    volatile ConnectionManagementSettings serverSettings;
    private static final PolicyConnectionManagementSettingsHolder instance = new PolicyConnectionManagementSettingsHolder();

    public static PolicyConnectionManagementSettingsHolder getInstance() {
        return instance;
    }

    public ConnectionManagementSettings getClientSettings() {
        return this.clientSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionManagementSettings getServerSettings() {
        if (this.serverSettings == null) {
            PolicyConnectionManagementSettingsHolder policyConnectionManagementSettingsHolder = this;
            synchronized (policyConnectionManagementSettingsHolder) {
                if (this.serverSettings == null) {
                    WSEndpoint<ServiceChannelWSImpl> endpoint = ServiceChannelCreator.getServiceChannelEndpointInstance();
                    this.serverSettings = PolicyConnectionManagementSettingsHolder.createSettingsInstance(endpoint.getPort());
                }
            }
        }
        return this.serverSettings;
    }

    @NotNull
    static ConnectionManagementSettings createSettingsInstance(@NotNull WSDLPort port) {
        try {
            WSDLModel model = port.getBinding().getOwner();
            WSDLPolicyMapWrapper mapWrapper = model.getExtension(WSDLPolicyMapWrapper.class);
            if (mapWrapper != null) {
                PolicyMap policyMap = mapWrapper.getPolicyMap();
                PolicyMapKey endpointKey = PolicyMap.createWsdlEndpointScopeKey(com.sun.xml.ws.transport.tcp.util.TCPConstants.SERVICE_CHANNEL_WS_NAME, com.sun.xml.ws.transport.tcp.util.TCPConstants.SERVICE_CHANNEL_WS_PORT_NAME);
                Policy policy = policyMap.getEndpointEffectivePolicy(endpointKey);
                if (policy != null && policy.contains(TCPConstants.TCPTRANSPORT_CONNECTION_MANAGEMENT_ASSERTION)) {
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(TCPConstants.TCPTRANSPORT_CONNECTION_MANAGEMENT_ASSERTION)) continue;
                            int highWatermark = PolicyConnectionManagementSettingsHolder.getAssertionAttrValue(assertion, "HighWatermark");
                            int maxParallelConnections = PolicyConnectionManagementSettingsHolder.getAssertionAttrValue(assertion, "MaxParallelConnections");
                            int numberToReclaim = PolicyConnectionManagementSettingsHolder.getAssertionAttrValue(assertion, "NumberToReclaim");
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, MessagesMessages.WSTCP_1130_CONNECTION_MNGMNT_SETTINGS_LOADED(highWatermark, maxParallelConnections, numberToReclaim));
                            }
                            return new ConnectionManagementSettings(highWatermark, maxParallelConnections, numberToReclaim);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ConnectionManagementSettings(-1, -1, -1);
    }

    private static int getAssertionAttrValue(PolicyAssertion assertion, String attrName) {
        String strValue = assertion.getAttributeValue(new QName(attrName));
        if (strValue != null) {
            strValue = strValue.trim();
            return Integer.parseInt(strValue);
        }
        return -1;
    }
}

