/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.impl.kerberos.KerberosContext;
import com.sun.xml.ws.security.opt.api.keyinfo.BinarySecurityToken;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.OctectStreamData;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.util.logging.Level;

public class KerberosTokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.KerberosTokenBinding binding = null;

    public KerberosTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.KerberosTokenBinding binding) {
        super(context);
        this.binding = binding;
    }

    public BuilderResult process() throws XWSSecurityException {
        String id = this.binding.getUUID();
        if (id == null || id.equals("")) {
            id = this.context.generateID();
        }
        String encodedRef = (String)this.context.getExtraneousProperty("KerbSHA1Value");
        KerberosContext krbContext = null;
        if (encodedRef != null) {
            krbContext = this.context.getKerberosContext(encodedRef);
        }
        boolean setOnce = false;
        if (krbContext != null) {
            setOnce = krbContext.setOnce();
        }
        this.setIncludeTokenPolicy(setOnce);
        String referenceType = this.binding.getReferenceType();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, LogStringsMessages.WSS_1853_REFERENCETYPE_KERBEROS_TOKEN(referenceType));
        }
        BuilderResult result = new BuilderResult();
        if (referenceType.equals("Direct")) {
            BinarySecurityToken bst = this.createKerberosBST(this.binding, this.binding.getTokenValue(), setOnce);
            if (bst == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
                throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
            }
            DirectReference dr = this.buildDirectReference(bst.getId(), "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#GSS_Kerberosv5_AP_REQ");
            this.buildKeyInfo(dr, this.binding.getSTRID());
        } else if (referenceType.equals("Identifier")) {
            BinarySecurityToken bst = this.createKerberosBST(this.binding, this.binding.getTokenValue(), setOnce);
            this.buildKeyInfoWithKIKerberos(this.binding, "http://docs.oasis-open.org/wss/oasis-wss-kerberos-token-profile-1.1#Kerberosv5APREQSHA1");
            if (this.binding.getSTRID() != null) {
                OctectStreamData osd = new OctectStreamData(new String(this.binding.getTokenValue()));
                this.context.getElementCache().put(this.binding.getSTRID(), osd);
            }
        } else {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
        }
        result.setKeyInfo(this.keyInfo);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setIncludeTokenPolicy(boolean setOnce) {
        block7: {
            block6: {
                if (!this.binding.policyTokenWasSet()) {
                    return;
                }
                if (AuthenticationTokenPolicy.KerberosTokenBinding.INCLUDE_ALWAYS.equals(this.binding.getIncludeToken())) break block6;
                if (!AuthenticationTokenPolicy.KerberosTokenBinding.INCLUDE_ALWAYS_TO_RECIPIENT.equals(this.binding.getIncludeToken())) break block7;
            }
            this.binding.setReferenceType("Direct");
            return;
        }
        if (AuthenticationTokenPolicy.KerberosTokenBinding.INCLUDE_NEVER.equals(this.binding.getIncludeToken())) {
            this.binding.setReferenceType("Identifier");
            return;
        }
        if (!AuthenticationTokenPolicy.KerberosTokenBinding.INCLUDE_ONCE.equals(this.binding.getIncludeToken())) return;
        if (setOnce) {
            this.binding.setReferenceType("Direct");
            return;
        }
        this.binding.setReferenceType("Identifier");
    }
}

