/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelToken
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.RelToken,
SecurityAssertionValidator {
    private String id;
    private List<String> tokenRefType;
    private boolean populated = false;
    private String tokenType;
    private PolicyAssertion rdKey = null;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean isServer = false;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private static QName itQname;
    private String includeToken;

    public RelToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    @Override
    public String getTokenType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public Iterator getTokenRefernceType() {
        if (this.tokenRefType != null) {
            return this.tokenRefType.iterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.rdKey != null;
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy = this.getNestedPolicy();
            this.includeToken = this.getAttributeValue(itQname);
            if (policy == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet as = policy.getAssertionSet();
            for (PolicyAssertion assertion : as) {
                if (PolicyUtil.isRelTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart().intern();
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.rdKey = assertion;
                    continue;
                }
                if (PolicyUtil.isRequireKeyIR(assertion, this.spVersion)) {
                    if (this.tokenRefType == null) {
                        this.tokenRefType = new ArrayList<String>();
                    }
                    this.tokenRefType.add(assertion.getName().getLocalPart().intern());
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "RelToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }
}

