/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Headers;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Engine;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.rm.CloseSequenceException;
import com.sun.xml.ws.rm.CreateSequenceException;
import com.sun.xml.ws.rm.RMException;
import com.sun.xml.ws.rm.RMMessage;
import com.sun.xml.ws.rm.RMVersion;
import com.sun.xml.ws.rm.TerminateSequenceException;
import com.sun.xml.ws.rm.jaxws.runtime.InboundMessageProcessor;
import com.sun.xml.ws.rm.jaxws.runtime.OutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.SequenceConfig;
import com.sun.xml.ws.rm.jaxws.runtime.client.ClientOutboundSequence;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.localization.RmLogger;
import com.sun.xml.ws.rm.protocol.AbstractAckRequested;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequence;
import com.sun.xml.ws.rm.protocol.AbstractCreateSequenceResponse;
import com.sun.xml.ws.rm.protocol.AbstractTerminateSequence;
import com.sun.xml.ws.rm.v200502.SequenceElement;
import com.sun.xml.ws.rm.v200702.AckRequestedElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceElement;
import com.sun.xml.ws.rm.v200702.CloseSequenceResponseElement;
import com.sun.xml.ws.rm.v200702.Identifier;
import com.sun.xml.ws.rm.v200702.UsesSequenceSTR;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;

public class ProtocolMessageSender {
    private static final RmLogger LOGGER = RmLogger.getLogger(ProtocolMessageSender.class);
    private SequenceConfig config;
    private final Engine engine;
    private final Tube nextTube;
    private BindingProvider proxy;
    private ContentNegotiation contentNegotiation;
    private Unmarshaller unmarshaller;

    public ProtocolMessageSender(SequenceConfig config, Unmarshaller unmarshaller, Tube nextTube, BindingProvider proxy, ContentNegotiation contentNegotiation) {
        this.unmarshaller = unmarshaller;
        this.config = config;
        this.proxy = proxy;
        this.contentNegotiation = contentNegotiation;
        this.nextTube = nextTube;
        Fiber currentFiber = Fiber.current();
        if (currentFiber == null) {
            throw LOGGER.logSevereException(new IllegalStateException("No current fiber found"));
        }
        this.engine = currentFiber.owner;
    }

    public AbstractCreateSequenceResponse sendCreateSequence(AbstractCreateSequence cs, URI destination, URI acksTo, boolean secureReliableMessaging) throws RMException {
        AbstractCreateSequenceResponse csrElem = null;
        if (cs != null) {
            Message request = Messages.create(this.config.getRMVersion().jaxbContext, (Object)cs, this.config.getSoapVersion());
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.proxy;
            requestPacket.contentNegotiation = this.contentNegotiation;
            requestPacket.setEndPointAddressString(destination.toString());
            this.addAddressingHeaders(requestPacket, this.config.getRMVersion().createSequenceAction, destination, false);
            if (secureReliableMessaging) {
                this.addSecurityHeaders(requestPacket);
            }
            Packet responsePacket = this.process(requestPacket);
            if (acksTo.equals(this.config.getAnonymousAddressingUri())) {
                Message response = responsePacket.getMessage();
                if (response != null) {
                    if (response.isFault()) {
                        throw LOGGER.logSevereException(new CreateSequenceException("CreateSequence was refused by the RMDestination \n ", response));
                    }
                    csrElem = this.unmarshallCreateSequenceResponse(response);
                }
            } else {
                throw LOGGER.logSevereException(new RMException("Addressable endpoints are currently not supported"));
            }
        }
        return csrElem;
    }

    public void sendTerminateSequence(AbstractTerminateSequence ts, OutboundSequence seq) throws RMException {
        Message request = Messages.create(this.config.getRMVersion().jaxbContext, (Object)ts, this.config.getSoapVersion());
        seq.processAcknowledgement(new RMMessage(request));
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.proxy;
        requestPacket.contentNegotiation = this.contentNegotiation;
        this.addAddressingHeaders(requestPacket, this.config.getRMVersion().terminateSequenceAction, seq.getDestination(), false);
        requestPacket.setEndPointAddressString(seq.getDestination().toString());
        Packet responsePacket = this.process(requestPacket);
        Message response = responsePacket.getMessage();
        if (response != null && response.isFault()) {
            throw LOGGER.logException(new TerminateSequenceException("There was an error trying to terminate the sequence ", response), Level.WARNING);
        }
    }

    public void sendLast(OutboundSequence seq) throws RMException {
        Message request = this.createEmptyMessage(this.config.getSoapVersion());
        SequenceElement el = this.createLastHeader(seq);
        request.getHeaders().add(this.createHeader(el));
        seq.setLast();
        Packet requestPacket = new Packet(request);
        requestPacket.proxy = this.proxy;
        requestPacket.setEndPointAddressString(seq.getDestination().toString());
        requestPacket.contentNegotiation = this.contentNegotiation;
        this.addAddressingHeaders(requestPacket, this.config.getRMVersion().lastAction, seq.getDestination(), false);
        Packet responsePacket = this.process(requestPacket);
        Message response = responsePacket.getMessage();
        RMMessage rmResponse = new RMMessage(response);
        if (response != null && response.isFault()) {
            throw LOGGER.logException(new RMException("Error sending Last message", response), Level.WARNING);
        }
        InboundMessageProcessor.processMessage(rmResponse, this.unmarshaller, RMSource.getRMSource(), this.config.getRMVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAckRequested(OutboundSequence seq, SOAPVersion version) throws RMException {
        try {
            Message request = this.createEmptyMessage(version);
            AbstractAckRequested el = this.createAckRequestedElement(seq);
            request.getHeaders().add(this.createHeader(el));
            Packet requestPacket = new Packet(request);
            requestPacket.proxy = this.proxy;
            requestPacket.contentNegotiation = this.contentNegotiation;
            this.addAddressingHeaders(requestPacket, this.config.getRMVersion().ackRequestedAction, seq.getDestination(), false);
            requestPacket.setEndPointAddressString(seq.getDestination().toString());
            Packet responsePacket = this.process(requestPacket);
            Message response = responsePacket.getMessage();
            if (response != null && response.isFault()) {
                ((ClientOutboundSequence)seq).resetLastActivityTime();
                throw LOGGER.logException(new RMException("Error sending AckRequestedElement", response), Level.WARNING);
            }
            InboundMessageProcessor.processMessage(new RMMessage(response), this.unmarshaller, RMSource.getRMSource(), this.config.getRMVersion());
        }
        finally {
            ((ClientOutboundSequence)seq).resetLastActivityTime();
        }
    }

    private Packet addAddressingHeaders(Packet requestPacket, String action, URI destination, boolean oneWay) throws RMException {
        if (oneWay) {
            requestPacket.getMessage().assertOneWay(true);
        } else {
            requestPacket.getMessage().assertOneWay(false);
        }
        requestPacket.setEndPointAddressString(destination.toString());
        requestPacket.getMessage().getHeaders().fillRequestAddressingHeaders(requestPacket, this.config.getAddressingVersion(), this.config.getSoapVersion(), oneWay, action);
        return requestPacket;
    }

    private void addSecurityHeaders(Packet requestPacket) {
        if (this.config.getRMVersion() == RMVersion.WSRM11) {
            HeaderList headerList = requestPacket.getMessage().getHeaders();
            UsesSequenceSTR usesSequenceSTR = new UsesSequenceSTR();
            usesSequenceSTR.getOtherAttributes().put(new QName(this.config.getSoapVersion().nsUri, "mustUnderstand"), "true");
            headerList.add(this.createHeader(usesSequenceSTR));
        }
    }

    private Message createEmptyMessage(SOAPVersion version) {
        return Messages.createEmpty(version);
    }

    private AbstractCreateSequenceResponse unmarshallCreateSequenceResponse(Message response) throws RMException {
        try {
            return (AbstractCreateSequenceResponse)response.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RMException("Unable to unmarshall CreateSequenceResponse", e));
        }
    }

    private SequenceElement createLastHeader(OutboundSequence seq) {
        SequenceElement sequenceElement = new SequenceElement();
        sequenceElement.setId(seq.getId());
        sequenceElement.setNumber(seq.getNextIndex());
        sequenceElement.setLastMessage(new SequenceElement.LastMessage());
        return sequenceElement;
    }

    private AbstractAckRequested createAckRequestedElement(OutboundSequence seq) {
        AbstractAckRequested ackRequestedElement = null;
        if (this.config.getRMVersion() == RMVersion.WSRM10) {
            ackRequestedElement = new com.sun.xml.ws.rm.v200502.AckRequestedElement();
            ackRequestedElement.setId(seq.getId());
        } else {
            ackRequestedElement = new AckRequestedElement();
            ackRequestedElement.setId(seq.getId());
        }
        return ackRequestedElement;
    }

    private Header createHeader(Object obj) {
        return Headers.create(this.config.getRMVersion().jaxbContext, obj);
    }

    public void sendCloseSequence(OutboundSequence seq) throws RMException {
        Identifier idClose = new Identifier();
        idClose.setValue(seq.getId());
        CloseSequenceElement cs = new CloseSequenceElement();
        cs.setIdentifier(idClose);
        cs.setLastMsgNumber(seq.getNextIndex() - 1);
        Packet requestPacket = new Packet(Messages.create(this.config.getRMVersion().jaxbContext, (Object)cs, this.config.getSoapVersion()));
        requestPacket.proxy = this.proxy;
        requestPacket.contentNegotiation = this.contentNegotiation;
        requestPacket.setEndPointAddressString(seq.getDestination().toString());
        this.addAddressingHeaders(requestPacket, RMVersion.WSRM11.closeSequenceAction, seq.getDestination(), false);
        seq.setClosed();
        Packet responsePacket = this.process(requestPacket);
        Message response = responsePacket.getMessage();
        if (response.isFault()) {
            throw LOGGER.logException(new CloseSequenceException("CloseSequence was refused by the RMDestination", response), Level.WARNING);
        }
        this.unmarshallCloseSequenceResponse(response);
    }

    private CloseSequenceResponseElement unmarshallCloseSequenceResponse(Message response) throws RMException {
        try {
            return (CloseSequenceResponseElement)response.readPayloadAsJAXB(this.unmarshaller);
        }
        catch (JAXBException e) {
            throw LOGGER.logSevereException(new RMException("Unable to unmarshall CloseSequenceResponse", e));
        }
    }

    private Packet process(Packet request) throws RMException {
        Fiber fiber = this.engine.createFiber();
        Tube tubeline = TubeCloner.clone(this.nextTube);
        return fiber.runSync(tubeline, request);
    }
}

