/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws;

import com.sun.xml.ws.api.model.wsdl.WSDLExtension;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.AssertionValidationProcessor;
import com.sun.xml.ws.policy.EffectiveAlternativeSelector;
import com.sun.xml.ws.policy.EffectivePolicyModifier;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapExtender;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.PolicySubject;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import com.sun.xml.ws.policy.spi.PolicyAssertionValidator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.ws.WebServiceException;

public class WSDLPolicyMapWrapper
implements WSDLExtension {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(WSDLPolicyMapWrapper.class);
    private static final QName NAME = new QName(null, "WSDLPolicyMapWrapper");
    private static ModelConfiguratorProvider[] configurators = PolicyUtils.ServiceProvider.load(ModelConfiguratorProvider.class);
    private PolicyMap policyMap;
    private EffectivePolicyModifier mapModifier;
    private PolicyMapExtender mapExtender;

    protected WSDLPolicyMapWrapper(PolicyMap policyMap) {
        if (policyMap == null) {
            throw new IllegalArgumentException(LocalizationMessages.WSP_1016_POLICY_MAP_CAN_NOT_BE_NULL());
        }
        this.policyMap = policyMap;
    }

    public WSDLPolicyMapWrapper(PolicyMap policyMap, EffectivePolicyModifier modifier, PolicyMapExtender extender) {
        this(policyMap);
        this.mapModifier = modifier;
        this.mapExtender = extender;
    }

    public PolicyMap getPolicyMap() {
        return this.policyMap;
    }

    void addClientConfigToMap(Object clientWsitConfigId, PolicyMap clientPolicyMap) throws PolicyException {
        LOGGER.entering();
        try {
            Policy policy;
            for (PolicyMapKey key : clientPolicyMap.getAllServiceScopeKeys()) {
                policy = clientPolicyMap.getServiceEffectivePolicy(key);
                this.mapExtender.putServiceSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            for (PolicyMapKey key : clientPolicyMap.getAllEndpointScopeKeys()) {
                policy = clientPolicyMap.getEndpointEffectivePolicy(key);
                this.mapExtender.putEndpointSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            for (PolicyMapKey key : clientPolicyMap.getAllOperationScopeKeys()) {
                policy = clientPolicyMap.getOperationEffectivePolicy(key);
                this.mapExtender.putOperationSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            for (PolicyMapKey key : clientPolicyMap.getAllInputMessageScopeKeys()) {
                policy = clientPolicyMap.getInputMessageEffectivePolicy(key);
                this.mapExtender.putInputMessageSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            for (PolicyMapKey key : clientPolicyMap.getAllOutputMessageScopeKeys()) {
                policy = clientPolicyMap.getOutputMessageEffectivePolicy(key);
                this.mapExtender.putOutputMessageSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            for (PolicyMapKey key : clientPolicyMap.getAllFaultMessageScopeKeys()) {
                policy = clientPolicyMap.getFaultMessageEffectivePolicy(key);
                this.mapExtender.putFaultMessageSubject(key, new PolicySubject(clientWsitConfigId, policy));
            }
            LOGGER.fine(LocalizationMessages.WSP_1041_CLIENT_CFG_POLICIES_TRANSFERED_INTO_FINAL_POLICY_MAP(this.policyMap));
        }
        catch (FactoryConfigurationError ex) {
            throw LOGGER.logSevereException(new PolicyException(ex));
        }
        LOGGER.exiting();
    }

    public void doAlternativeSelection() throws PolicyException {
        EffectiveAlternativeSelector.doSelection(this.mapModifier);
    }

    void validateServerSidePolicies() throws PolicyException {
        AssertionValidationProcessor validationProcessor = AssertionValidationProcessor.getInstance();
        for (Policy policy : this.policyMap) {
            for (AssertionSet assertionSet : policy) {
                for (PolicyAssertion assertion : assertionSet) {
                    PolicyAssertionValidator.Fitness validationResult = validationProcessor.validateServerSide(assertion);
                    if (validationResult == PolicyAssertionValidator.Fitness.SUPPORTED) continue;
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1046_SERVER_SIDE_ASSERTION_VALIDATION_FAILED(assertion.getName(), (Object)validationResult)));
                }
            }
        }
    }

    void configureModel(WSDLModel model) {
        try {
            for (ModelConfiguratorProvider configurator : configurators) {
                configurator.configure(model, this.policyMap);
            }
        }
        catch (PolicyException e) {
            throw LOGGER.logSevereException(new WebServiceException(LocalizationMessages.WSP_1032_FAILED_CONFIGURE_WSDL_MODEL(), e));
        }
    }

    void putEndpointSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putEndpointSubject(key, subject);
        }
    }

    void putServiceSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putServiceSubject(key, subject);
        }
    }

    void putOperationSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putOperationSubject(key, subject);
        }
    }

    void putInputMessageSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putInputMessageSubject(key, subject);
        }
    }

    void putOutputMessageSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putOutputMessageSubject(key, subject);
        }
    }

    void putFaultMessageSubject(PolicyMapKey key, PolicySubject subject) {
        if (null != this.mapExtender) {
            this.mapExtender.putFaultMessageSubject(key, subject);
        }
    }

    public QName getName() {
        return NAME;
    }
}

