/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.Blitter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class ColorBlitter
implements Blitter {
    private ColorProcessor ip;
    private int width;
    private int height;
    private int[] pixels;
    private int transparent = 0xFFFFFF;

    public ColorBlitter(ColorProcessor ip) {
        this.ip = ip;
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.pixels = (int[])ip.getPixels();
    }

    public void setTransparentColor(Color c) {
        this.transparent = c.getRGB() & 0xFFFFFF;
    }

    public void copyBits(ImageProcessor ip, int xloc, int yloc, int mode) {
        int ySrcBase;
        int[] srcPixels;
        int srcWidth = ip.getWidth();
        int srcHeight = ip.getHeight();
        Rectangle rect1 = new Rectangle(srcWidth, srcHeight);
        rect1.setLocation(xloc, yloc);
        Rectangle rect2 = new Rectangle(this.width, this.height);
        if (!rect1.intersects(rect2)) {
            return;
        }
        if (ip instanceof ByteProcessor) {
            byte[] pixels8 = (byte[])ip.getPixels();
            ColorModel cm = ip.getColorModel();
            if (ip.isInvertedLut()) {
                cm = ip.getDefaultColorModel();
            }
            int size = ip.getWidth() * ip.getHeight();
            srcPixels = new int[size];
            int i = 0;
            while (i < size) {
                srcPixels[i] = cm.getRGB(pixels8[i] & 0xFF);
                ++i;
            }
        } else {
            srcPixels = (int[])ip.getPixels();
        }
        rect1 = rect1.intersection(rect2);
        int xSrcBase = xloc < 0 ? -xloc : 0;
        int n = ySrcBase = yloc < 0 ? -yloc : 0;
        if (mode == 0 || mode == 2 || mode == 14) {
            int y = rect1.y;
            while (y < rect1.y + rect1.height) {
                int i;
                int trancolor;
                int srcIndex = (y - yloc) * srcWidth + (rect1.x - xloc);
                int dstIndex = y * this.width + rect1.x;
                int n2 = trancolor = mode == 14 ? 0 : this.transparent;
                if (mode == 0) {
                    i = rect1.width;
                    while (--i >= 0) {
                        this.pixels[dstIndex++] = srcPixels[srcIndex++];
                    }
                } else {
                    i = rect1.width;
                    while (--i >= 0) {
                        int src = srcPixels[srcIndex++];
                        int dst = this.pixels[dstIndex];
                        int n3 = this.pixels[dstIndex++] = (src & 0xFFFFFF) == trancolor ? dst : src;
                    }
                }
                ++y;
            }
            return;
        }
        int y = rect1.y;
        while (y < rect1.y + rect1.height) {
            int srcIndex = (y - yloc) * srcWidth + (rect1.x - xloc);
            int dstIndex = y * this.width + rect1.x;
            int i = rect1.width;
            while (--i >= 0) {
                int c1 = srcPixels[srcIndex++];
                int r1 = (c1 & 0xFF0000) >> 16;
                int g1 = (c1 & 0xFF00) >> 8;
                int b1 = c1 & 0xFF;
                int c2 = this.pixels[dstIndex];
                int r2 = (c2 & 0xFF0000) >> 16;
                int g2 = (c2 & 0xFF00) >> 8;
                int b2 = c2 & 0xFF;
                switch (mode) {
                    case 1: {
                        break;
                    }
                    case 3: {
                        r2 = r1 + r2;
                        g2 = g1 + g2;
                        b2 = b1 + b2;
                        if (r2 > 255) {
                            r2 = 255;
                        }
                        if (g2 > 255) {
                            g2 = 255;
                        }
                        if (b2 <= 255) break;
                        b2 = 255;
                        break;
                    }
                    case 7: {
                        r2 = (r1 + r2) / 2;
                        g2 = (g1 + g2) / 2;
                        b2 = (b1 + b2) / 2;
                        break;
                    }
                    case 4: {
                        g2 -= g1;
                        b2 -= b1;
                        if ((r2 -= r1) < 0) {
                            r2 = 0;
                        }
                        if (g2 < 0) {
                            g2 = 0;
                        }
                        if (b2 >= 0) break;
                        b2 = 0;
                        break;
                    }
                    case 8: {
                        if ((r2 -= r1) < 0) {
                            r2 = -r2;
                        }
                        if ((g2 -= g1) < 0) {
                            g2 = -g2;
                        }
                        if ((b2 -= b1) >= 0) break;
                        b2 = -b2;
                        break;
                    }
                    case 5: {
                        r2 = r1 * r2;
                        g2 = g1 * g2;
                        b2 = b1 * b2;
                        if (r2 > 255) {
                            r2 = 255;
                        }
                        if (g2 > 255) {
                            g2 = 255;
                        }
                        if (b2 <= 255) break;
                        b2 = 255;
                        break;
                    }
                    case 6: {
                        r2 = r1 == 0 ? 255 : (r2 /= r1);
                        g2 = g1 == 0 ? 255 : (g2 /= g1);
                        if (b1 == 0) {
                            b2 = 255;
                            break;
                        }
                        b2 /= b1;
                        break;
                    }
                    case 9: {
                        r2 = r1 & r2;
                        g2 = g1 & g2;
                        b2 = b1 & b2;
                        break;
                    }
                    case 10: {
                        r2 = r1 | r2;
                        g2 = g1 | g2;
                        b2 = b1 | b2;
                        break;
                    }
                    case 11: {
                        r2 = r1 ^ r2;
                        g2 = g1 ^ g2;
                        b2 = b1 ^ b2;
                        break;
                    }
                    case 12: {
                        if (r1 < r2) {
                            r2 = r1;
                        }
                        if (g1 < g2) {
                            g2 = g1;
                        }
                        if (b1 >= b2) break;
                        b2 = b1;
                        break;
                    }
                    case 13: {
                        if (r1 > r2) {
                            r2 = r1;
                        }
                        if (g1 > g2) {
                            g2 = g1;
                        }
                        if (b1 <= b2) break;
                        b2 = b1;
                    }
                }
                this.pixels[dstIndex++] = -16777216 + (r2 << 16) + (g2 << 8) + b2;
            }
            if (y % 20 == 0) {
                ip.showProgress((double)(y - rect1.y) / (double)rect1.height);
            }
            ++y;
        }
        ip.showProgress(1.0);
    }
}

