/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugIn {
    static boolean processStack;
    static boolean invertY;
    static boolean suppress;

    public void run(String arg) {
        SaveDialog sd;
        String name;
        int digits;
        boolean rgb;
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        int width = imp.getWidth();
        int height = imp.getHeight();
        double background = ip.getPixelValue(0, 0);
        String bg = " \n";
        boolean bl = rgb = imp.getBitDepth() == 24;
        if (rgb) {
            int c = ip.getPixel(0, 0);
            int r = (c & 0xFF0000) >> 16;
            int g = (c & 0xFF00) >> 8;
            int b = c & 0xFF;
            bg = String.valueOf(r) + "," + g + "," + b;
            bg = " \n    Background value: " + bg + "\n";
        }
        imp.deleteRoi();
        int slices = imp.getStackSize();
        String msg = "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\ndefaults to be the value of the pixel in the upper\nleft corner of the image.\n" + bg;
        GenericDialog gd = new GenericDialog("Save XY Coordinates");
        gd.addMessage(msg);
        int n = digits = (double)((int)background) == background ? 0 : 4;
        if (!rgb) {
            gd.setInsets(5, 35, 3);
            gd.addNumericField("Background value:", background, digits);
        }
        gd.setInsets(10, 35, 0);
        gd.addCheckbox("Invert y coordinates off (0 at top of image)", invertY);
        gd.setInsets(0, 35, 0);
        gd.addCheckbox("Suppress Log output", suppress);
        if (slices > 1) {
            gd.setInsets(0, 35, 0);
            gd.addCheckbox("Process all " + slices + " images", processStack);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (!rgb) {
            background = gd.getNextNumber();
        }
        invertY = gd.getNextBoolean();
        suppress = gd.getNextBoolean();
        processStack = slices > 1 ? gd.getNextBoolean() : false;
        if (!processStack) {
            slices = 1;
        }
        if ((name = (sd = new SaveDialog("Save Coordinates as Text...", imp.getTitle(), ".txt")).getFileName()) == null) {
            return;
        }
        String directory = sd.getDirectory();
        PrintWriter pw = null;
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(directory) + name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            pw = new PrintWriter(bos);
        }
        catch (IOException e) {
            IJ.write("" + e);
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int count = 0;
        int type = imp.getType();
        ImageStack stack = imp.getStack();
        int z = 0;
        while (z < slices) {
            String img;
            if (slices > 1) {
                ip = stack.getProcessor(z + 1);
            }
            String zstr = slices > 1 ? String.valueOf(z) + "\t" : "";
            int i = 0;
            while (i < height) {
                int y = invertY ? i : height - 1 - i;
                int x = 0;
                while (x < width) {
                    float v = ip.getPixelValue(x, y);
                    if ((double)v != background) {
                        if (type == 2) {
                            pw.println(String.valueOf(x) + "\t" + (invertY ? y : height - 1 - y) + "\t" + zstr + v);
                        } else if (rgb) {
                            int c = ip.getPixel(x, y);
                            int r = (c & 0xFF0000) >> 16;
                            int g = (c & 0xFF00) >> 8;
                            int b = c & 0xFF;
                            pw.println(String.valueOf(x) + "\t" + (invertY ? y : height - 1 - y) + "\t" + zstr + r + "\t" + g + "\t" + b);
                        } else {
                            pw.println(String.valueOf(x) + "\t" + (invertY ? y : height - 1 - y) + "\t" + zstr + (int)v);
                        }
                        ++count;
                    }
                    ++x;
                }
                if (slices == 1 && y % 10 == 0) {
                    IJ.showProgress((double)(height - y) / (double)height);
                }
                ++i;
            }
            if (slices > 1) {
                IJ.showProgress(z + 1, slices);
            }
            String string = img = slices > 1 ? "-" + (z + 1) : "";
            if (!suppress) {
                IJ.log(String.valueOf(imp.getTitle()) + img + ": " + count + " pixels (" + IJ.d2s((double)count * 100.0 / (double)(width * height)) + "%)\n");
            }
            count = 0;
            ++z;
        }
        IJ.showProgress(1.0);
        IJ.showStatus("");
        pw.close();
    }
}

