/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.Executer;
import ij.IJ;
import ij.Menus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.StringSorter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Hotkeys
implements PlugIn {
    private static final String TITLE = "Hotkeys";
    private static String command = "";
    private static String shortcut = "";
    static /* synthetic */ Class class$0;

    public void run(String arg) {
        Class<?> clazz;
        if (arg.equals("install")) {
            this.installHotkey();
        } else if (arg.equals("remove")) {
            this.removeHotkey();
        } else {
            Executer e = new Executer(arg);
            e.run();
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("ij.plugin.Hotkeys");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJ.register(clazz);
    }

    void installHotkey() {
        String[] commands = this.getAllCommands();
        String[] shortcuts = this.getAvailableShortcuts();
        GenericDialog gd = new GenericDialog("Create Shortcut");
        gd.addChoice("Command:", commands, command);
        gd.addChoice("Shortcut:", shortcuts, shortcuts[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        command = gd.getNextChoice();
        shortcut = gd.getNextChoice();
        String plugin = "ij.plugin.Hotkeys(\"" + command + "\")";
        int err = Menus.installPlugin(plugin, 'h', "*" + command, shortcut, IJ.getInstance());
        switch (err) {
            case -1: {
                IJ.showMessage(TITLE, "The command \"" + command + "\" is already installed.");
                break;
            }
            case -2: {
                IJ.showMessage(TITLE, "The shortcut must be a single character or F1-F24.");
                break;
            }
            case -3: {
                IJ.showMessage("The \"" + shortcut + "\" shortcut is already being used.");
                break;
            }
            default: {
                shortcut = "";
            }
        }
    }

    void removeHotkey() {
        String[] commands = this.getInstalledCommands();
        if (commands == null) {
            IJ.showMessage("Remove...", "No installed commands found.");
            return;
        }
        GenericDialog gd = new GenericDialog("Remove");
        gd.addChoice("Command:", commands, "");
        gd.addMessage("The command is not removed\nuntil ImageJ is restarted.");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        command = gd.getNextChoice();
        int err = Menus.uninstallPlugin(command);
        boolean removed = true;
        if (err == -5) {
            removed = this.deletePlugin(command);
        }
        if (removed) {
            IJ.showStatus("\"" + command + "\" removed; ImageJ restart required");
        } else {
            IJ.showStatus("\"" + command + "\" not removed");
        }
    }

    boolean deletePlugin(String command) {
        String plugin = (String)Menus.getCommands().get(command);
        String name = String.valueOf(plugin) + ".class";
        File file = new File(Menus.getPlugInsPath(), name);
        if (file == null || !file.exists()) {
            return false;
        }
        return IJ.showMessageWithCancel("Delete Plugin?", "Permanently delete \"" + name + "\"?");
    }

    String[] getAllCommands() {
        Vector<String> v = new Vector<String>();
        Hashtable commandTable = Menus.getCommands();
        Hashtable shortcuts = Menus.getShortcuts();
        Enumeration en = commandTable.keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (cmd.startsWith("*") || cmd.startsWith(" ") || cmd.length() >= 35 || shortcuts.contains(cmd)) continue;
            v.addElement(cmd);
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }

    String[] getAvailableShortcuts() {
        String shortcut;
        Vector<String> v = new Vector<String>();
        Hashtable shortcuts = Menus.getShortcuts();
        char c = '0';
        while (c <= '9') {
            shortcut = "" + c;
            if (!Menus.shortcutInUse(shortcut)) {
                v.add(shortcut);
            }
            c = (char)(c + '\u0001');
        }
        c = 'a';
        while (c <= 'z') {
            shortcut = "" + c;
            if (!Menus.shortcutInUse(shortcut)) {
                v.add(shortcut);
            }
            c = (char)(c + '\u0001');
        }
        c = 'A';
        while (c <= 'Z') {
            shortcut = "" + c;
            if (!Menus.shortcutInUse(shortcut)) {
                v.add(shortcut);
            }
            c = (char)(c + '\u0001');
        }
        int i = 1;
        while (i <= 12) {
            shortcut = "F" + i;
            if (!Menus.shortcutInUse(shortcut)) {
                v.add(shortcut);
            }
            ++i;
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        return list;
    }

    String[] getInstalledCommands() {
        Vector<String> v = new Vector<String>();
        Hashtable commandTable = Menus.getCommands();
        Enumeration en = commandTable.keys();
        while (en.hasMoreElements()) {
            String cmd = (String)en.nextElement();
            if (!cmd.startsWith("*")) continue;
            v.addElement(cmd);
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] list = new String[v.size()];
        v.copyInto(list);
        StringSorter.sort((String[])list);
        return list;
    }
}

