/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.gui.Toolbar;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.FolderOpener;
import ij.plugin.PlugIn;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DragAndDrop
implements PlugIn,
DropTargetListener,
Runnable {
    private Iterator iterator;
    private static boolean convertToRGB;
    private static boolean virtualStack;
    private boolean openAsVirtualStack;
    static /* synthetic */ Class class$0;

    public void run(String arg) {
        ImageJ ij = IJ.getInstance();
        ij.setDropTarget(null);
        new DropTarget(ij, this);
        new DropTarget(Toolbar.getInstance(), this);
        new DropTarget(ij.getStatusBar(), this);
    }

    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(1);
        DataFlavor[] flavors = null;
        try {
            Transferable t = dtde.getTransferable();
            this.iterator = null;
            flavors = t.getTransferDataFlavors();
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.drop: " + flavors.length + " flavors");
            }
            int i = 0;
            while (i < flavors.length) {
                Object ob;
                if (IJ.debugMode) {
                    IJ.log("  flavor[" + i + "]: " + flavors[i].getMimeType());
                }
                if (flavors[i].isFlavorJavaFileListType()) {
                    Object data = t.getTransferData(DataFlavor.javaFileListFlavor);
                    this.iterator = ((List)data).iterator();
                    break;
                }
                if (flavors[i].isFlavorTextType() && (ob = t.getTransferData(flavors[i])) instanceof String) {
                    String tmp;
                    String s = ob.toString().trim();
                    if (IJ.isLinux() && s.length() > 1 && s.charAt(1) == '\u0000') {
                        s = this.fixLinuxString(s);
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (s.indexOf("href=\"") != -1 || s.indexOf("src=\"") != -1) {
                        s = this.parseHTML(s);
                        if (IJ.debugMode) {
                            IJ.log("  url: " + s);
                        }
                        list.add(s);
                        this.iterator = list.iterator();
                        break;
                    }
                    BufferedReader br = new BufferedReader(new StringReader(s));
                    while ((tmp = br.readLine()) != null) {
                        if ((tmp = URLDecoder.decode(tmp.replaceAll("\\+", "%2b"), "UTF-8")).startsWith("file://")) {
                            tmp = tmp.substring(7);
                        }
                        if (IJ.debugMode) {
                            IJ.log("  content: " + tmp);
                        }
                        if (tmp.startsWith("http://")) {
                            list.add(s);
                            continue;
                        }
                        list.add(new File(tmp));
                    }
                    this.iterator = list.iterator();
                    break;
                }
                ++i;
            }
            if (this.iterator != null) {
                Thread thread = new Thread((Runnable)this, "DrawAndDrop");
                thread.setPriority(Math.max(thread.getPriority() - 1, 1));
                thread.start();
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
        if (flavors == null || flavors.length == 0) {
            if (IJ.isMacOSX()) {
                IJ.error("First drag and drop ignored. Please try again. You can avoid this\nproblem by dragging to the toolbar instead of the status bar.");
            } else {
                IJ.error("Drag and drop failed");
            }
        }
    }

    private String fixLinuxString(String s) {
        StringBuffer sb = new StringBuffer(200);
        int i = 0;
        while (i < s.length()) {
            sb.append(s.charAt(i));
            i += 2;
        }
        return new String(sb);
    }

    private String parseHTML(String s) {
        int index2;
        int index1;
        if (IJ.debugMode) {
            IJ.log("parseHTML:\n" + s);
        }
        if ((index1 = s.indexOf("src=\"")) >= 0 && (index2 = s.indexOf("\"", index1 + 5)) > 0) {
            return s.substring(index1 + 5, index2);
        }
        index1 = s.indexOf("href=\"");
        if (index1 >= 0 && (index2 = s.indexOf("\"", index1 + 6)) > 0) {
            return s.substring(index1 + 6, index2);
        }
        return s;
    }

    public void dragEnter(DropTargetDragEvent e) {
        IJ.showStatus("<<Drag and Drop>>");
        if (IJ.debugMode) {
            IJ.log("DragEnter: " + e.getLocation());
        }
        e.acceptDrag(1);
        this.openAsVirtualStack = false;
    }

    public void dragOver(DropTargetDragEvent e) {
        if (IJ.debugMode) {
            IJ.log("DragOver: " + e.getLocation());
        }
        Point loc = e.getLocation();
        int width = IJ.getInstance().getSize().width;
        int buttonSize = Toolbar.getButtonSize();
        boolean bl = this.openAsVirtualStack = width - loc.x <= buttonSize;
        if (this.openAsVirtualStack) {
            IJ.showStatus("<<Open as Virtual Stack>>");
        } else {
            IJ.showStatus("<<Drag and Drop>>");
        }
    }

    public void dragExit(DropTargetEvent e) {
        IJ.showStatus("");
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    public void run() {
        Iterator iterator = this.iterator;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj != null && obj instanceof String) {
                this.openURL((String)obj);
                continue;
            }
            this.openFile((File)obj);
        }
    }

    private void openURL(String url) {
        if (IJ.debugMode) {
            IJ.log("DragAndDrop.openURL: " + url);
        }
        if (url != null) {
            IJ.open(url);
        }
    }

    public void openFile(File f) {
        block10: {
            if (IJ.debugMode) {
                IJ.log("DragAndDrop.openFile: " + f);
            }
            try {
                if (f == null) {
                    return;
                }
                String path = f.getCanonicalPath();
                if (f.exists()) {
                    if (f.isDirectory()) {
                        this.openDirectory(f, path);
                    } else {
                        if (this.openAsVirtualStack && (path.endsWith(".tif") || path.endsWith(".TIF"))) {
                            new FileInfoVirtualStack().run(path);
                        } else {
                            new Opener().openAndAddToRecent(path);
                        }
                        OpenDialog.setLastDirectory(String.valueOf(f.getParent()) + File.separator);
                        OpenDialog.setLastName(f.getName());
                    }
                } else {
                    IJ.log("File not found: " + path);
                }
            }
            catch (Throwable e) {
                if ("Macro canceled".equals(e.getMessage())) break block10;
                IJ.handleException(e);
            }
        }
    }

    private void openDirectory(File f, String path) {
        Class<?> clazz;
        if (path == null) {
            return;
        }
        if (!path.endsWith(File.separator) && !path.endsWith("/")) {
            path = String.valueOf(path) + File.separator;
        }
        String[] names = f.list();
        if ((names = new FolderOpener().trimFileList(names)) == null) {
            return;
        }
        String msg = "Open all " + names.length + " images in \"" + f.getName() + "\" as a stack?";
        GenericDialog gd = new GenericDialog("Open Folder");
        gd.setInsets(10, 5, 0);
        gd.addMessage(msg);
        gd.setInsets(15, 35, 0);
        gd.addCheckbox("Convert to RGB", convertToRGB);
        gd.setInsets(0, 35, 0);
        gd.addCheckbox("Use Virtual Stack", virtualStack);
        gd.enableYesNoCancel();
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        if (gd.wasOKed()) {
            convertToRGB = gd.getNextBoolean();
            virtualStack = gd.getNextBoolean();
            String options = " sort";
            if (convertToRGB) {
                options = String.valueOf(options) + " convert_to_rgb";
            }
            if (virtualStack) {
                options = String.valueOf(options) + " use";
            }
            IJ.run("Image Sequence...", "open=[" + path + "]" + options);
            DirectoryChooser.setDefaultDirectory(path);
        } else {
            int k = 0;
            while (k < names.length) {
                if (!names[k].startsWith(".")) {
                    IJ.redirectErrorMessages(true);
                    new Opener().open(String.valueOf(path) + names[k]);
                    IJ.redirectErrorMessages(false);
                }
                ++k;
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("ij.plugin.DragAndDrop");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJ.register(clazz);
    }
}

