/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

public class BitBuffer {
    private int currentByte;
    private int currentBit;
    private byte[] byteBuffer;
    private int eofByte;
    private int[] backMask;
    private int[] frontMask;
    private boolean eofFlag;

    public BitBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byteBuffer.length;
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        this.backMask = nArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 128;
        nArray2[2] = 192;
        nArray2[3] = 224;
        nArray2[4] = 240;
        nArray2[5] = 248;
        nArray2[6] = 252;
        nArray2[7] = 254;
        this.frontMask = nArray2;
    }

    public int getBits(int bitsToRead) {
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (bitsToRead >= 8 - this.currentBit) {
                if (this.currentBit == 0) {
                    toStore <<= 8;
                    cb = this.byteBuffer[this.currentByte];
                    toStore += cb < 0 ? 256 + cb : cb;
                    bitsToRead -= 8;
                    ++this.currentByte;
                } else {
                    toStore <<= 8 - this.currentBit;
                    toStore += this.byteBuffer[this.currentByte] & this.backMask[8 - this.currentBit];
                    bitsToRead -= 8 - this.currentBit;
                    this.currentBit = 0;
                    ++this.currentByte;
                }
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte];
                cb = cb < 0 ? 256 + cb : cb;
                toStore += (cb & 255 - this.frontMask[this.currentBit]) >> 8 - (this.currentBit + bitsToRead);
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }
}

