/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.xmlbeans.impl.piccolo.xml;

import com.fr.third.v2.org.apache.xmlbeans.impl.piccolo.io.CharsetDecoder;
import com.fr.third.v2.org.apache.xmlbeans.impl.piccolo.io.IllegalCharException;
import com.fr.third.v2.org.apache.xmlbeans.impl.piccolo.xml.XMLDecoder;
import java.io.CharConversionException;

public final class UnicodeLittleXMLDecoder
implements XMLDecoder {
    private boolean sawCR = false;

    public CharsetDecoder newCharsetDecoder() {
        return this.newXMLDecoder();
    }

    public XMLDecoder newXMLDecoder() {
        return new UnicodeLittleXMLDecoder();
    }

    public int minBytesPerChar() {
        return 2;
    }

    public int maxBytesPerChar() {
        return 2;
    }

    public void reset() {
        this.sawCR = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decode(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int o = 0;
        int i = 0;
        while (i + 1 < in_len && o < out_len) {
            char c = (char)((0xFF & in_buf[in_off + i + 1]) << 8 | 0xFF & in_buf[in_off + i]);
            if (c >= ' ') {
                if (c > '\ud7ff' && (c < '\ue000' || c > '\ufffd') && (c < '\u10000' || c > '\u10ffff')) throw new IllegalCharException("Illegal XML Character: 0x" + Integer.toHexString(c));
                this.sawCR = false;
                out_buf[out_off + o++] = c;
            } else {
                switch (c) {
                    case '\n': {
                        if (this.sawCR) {
                            this.sawCR = false;
                            break;
                        }
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\r': {
                        this.sawCR = true;
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o++] = 9;
                        break;
                    }
                    default: {
                        throw new IllegalCharException("Illegal XML character: 0x" + Integer.toHexString(c));
                    }
                }
            }
            i += 2;
        }
        result[0] = i;
        result[1] = o;
    }

    public void decodeXMLDecl(byte[] in_buf, int in_off, int in_len, char[] out_buf, int out_off, int out_len, int[] result) throws CharConversionException {
        int o = 0;
        int i = 0;
        block5: while (i + 1 < in_len && o < out_len) {
            char c = (char)((0xFF & in_buf[in_off + i + 1]) << 8 | 0xFF & in_buf[in_off + i]);
            if (c >= ' ') {
                if (c > '\ud7ff' && (c < '\ue000' || c > '\ufffd') && (c < '\u10000' || c > '\u10ffff')) break;
                this.sawCR = false;
                out_buf[out_off + o++] = c;
                if (c == '>') {
                    i += 2;
                    break;
                }
            } else {
                switch (c) {
                    case '\n': {
                        if (this.sawCR) {
                            this.sawCR = false;
                            break;
                        }
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\r': {
                        this.sawCR = true;
                        out_buf[out_off + o++] = 10;
                        break;
                    }
                    case '\t': {
                        out_buf[out_off + o++] = 9;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
            }
            i += 2;
        }
        result[0] = i;
        result[1] = o;
    }
}

