/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel.helpers;

import com.fr.third.v2.org.apache.poi.ss.formula.FormulaParseException;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaParser;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaRenderer;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaShifter;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.AreaPtg;
import com.fr.third.v2.org.apache.poi.ss.formula.ptg.Ptg;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Sheet;
import com.fr.third.v2.org.apache.poi.ss.util.CellRangeAddress;
import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCell;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFHyperlink;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFName;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRow;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCfRule;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTConditionalFormatting;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellFormulaType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XSSFRowShifter {
    private static POILogger logger = POILogFactory.getLogger(XSSFRowShifter.class);
    private final XSSFSheet sheet;

    public XSSFRowShifter(XSSFSheet sh) {
        this.sheet = sh;
    }

    public List<CellRangeAddress> shiftMerged(int startRow, int endRow, int n) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        HashSet<Integer> removedIndices = new HashSet<Integer>();
        int size = this.sheet.getNumMergedRegions();
        for (int i = 0; i < size; ++i) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (!inStart || !inEnd || XSSFRowShifter.containsCell(merged, startRow - 1, 0) || XSSFRowShifter.containsCell(merged, endRow + 1, 0)) continue;
            merged.setFirstRow(merged.getFirstRow() + n);
            merged.setLastRow(merged.getLastRow() + n);
            shiftedRegions.add(merged);
            removedIndices.add(i);
        }
        if (!removedIndices.isEmpty()) {
            this.sheet.removeMergedRegions(removedIndices);
        }
        for (CellRangeAddress region : shiftedRegions) {
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    public void updateNamedRanges(FormulaShifter shifter) {
        XSSFWorkbook wb = this.sheet.getWorkbook();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        for (int i = 0; i < wb.getNumberOfNames(); ++i) {
            int sheetIndex;
            XSSFName name = wb.getNameAt(i);
            String formula = name.getRefersToFormula();
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, 4, sheetIndex = name.getSheetIndex());
            if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
            String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
            name.setRefersToFormula(shiftedFmla);
        }
    }

    public void updateFormulas(FormulaShifter shifter) {
        this.updateSheetFormulas(this.sheet, shifter);
        XSSFWorkbook wb = this.sheet.getWorkbook();
        for (Sheet sh : wb) {
            if (this.sheet == sh) continue;
            this.updateSheetFormulas(sh, shifter);
        }
    }

    private void updateSheetFormulas(Sheet sh, FormulaShifter shifter) {
        for (Row r : sh) {
            XSSFRow row = (XSSFRow)r;
            this.updateRowFormulas(row, shifter);
        }
    }

    @Internal
    public void updateRowFormulas(XSSFRow row, FormulaShifter shifter) {
        for (Cell c : row) {
            String ref;
            String shiftedRef;
            String shiftedFormula;
            XSSFCell cell = (XSSFCell)c;
            CTCell ctCell = cell.getCTCell();
            if (!ctCell.isSetF()) continue;
            CTCellFormula f = ctCell.getF();
            String formula = f.getStringValue();
            if (formula.length() > 0 && (shiftedFormula = XSSFRowShifter.shiftFormula(row, formula, shifter)) != null) {
                f.setStringValue(shiftedFormula);
                if (f.getT() == STCellFormulaType.SHARED) {
                    int si = (int)f.getSi();
                    CTCellFormula sf = row.getSheet().getSharedFormula(si);
                    sf.setStringValue(shiftedFormula);
                }
            }
            if (!f.isSetRef() || (shiftedRef = XSSFRowShifter.shiftFormula(row, ref = f.getRef(), shifter)) == null) continue;
            f.setRef(shiftedRef);
        }
    }

    private static String shiftFormula(XSSFRow row, String formula, FormulaShifter shifter) {
        XSSFSheet sheet = row.getSheet();
        XSSFWorkbook wb = sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        try {
            Ptg[] ptgs = FormulaParser.parse(formula, fpb, 0, sheetIndex);
            String shiftedFmla = null;
            if (shifter.adjustFormula(ptgs, sheetIndex)) {
                shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
            }
            return shiftedFmla;
        }
        catch (FormulaParseException fpe) {
            logger.log(5, "Error shifting formula on row ", row.getRowNum(), fpe);
            return formula;
        }
    }

    public void updateConditionalFormatting(FormulaShifter shifter) {
        XSSFWorkbook wb = this.sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(this.sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        CTWorksheet ctWorksheet = this.sheet.getCTWorksheet();
        CTConditionalFormatting[] conditionalFormattingArray = ctWorksheet.getConditionalFormattingArray();
        for (int j = conditionalFormattingArray.length - 1; j >= 0; --j) {
            CTConditionalFormatting cf = conditionalFormattingArray[j];
            ArrayList<CellRangeAddress> cellRanges = new ArrayList<CellRangeAddress>();
            for (Object stRef : cf.getSqref()) {
                String[] regions = stRef.toString().split(" ");
                for (String region : regions) {
                    cellRanges.add(CellRangeAddress.valueOf(region));
                }
            }
            boolean changed = false;
            ArrayList<CellRangeAddress> temp = new ArrayList<CellRangeAddress>();
            for (CellRangeAddress craOld : cellRanges) {
                CellRangeAddress craNew = XSSFRowShifter.shiftRange(shifter, craOld, sheetIndex);
                if (craNew == null) {
                    changed = true;
                    continue;
                }
                temp.add(craNew);
                if (craNew == craOld) continue;
                changed = true;
            }
            if (changed) {
                int nRanges = temp.size();
                if (nRanges == 0) {
                    ctWorksheet.removeConditionalFormatting(j);
                    continue;
                }
                ArrayList<String> refs = new ArrayList<String>();
                for (CellRangeAddress a : temp) {
                    refs.add(a.formatAsString());
                }
                cf.setSqref(refs);
            }
            for (CTCfRule cfRule : cf.getCfRuleArray()) {
                String[] formulaArray = cfRule.getFormulaArray();
                for (int i = 0; i < formulaArray.length; ++i) {
                    String formula = formulaArray[i];
                    Ptg[] ptgs = FormulaParser.parse(formula, fpb, 0, sheetIndex);
                    if (!shifter.adjustFormula(ptgs, sheetIndex)) continue;
                    String shiftedFmla = FormulaRenderer.toFormulaString(fpb, ptgs);
                    cfRule.setFormulaArray(i, shiftedFmla);
                }
            }
        }
    }

    public void updateHyperlinks(FormulaShifter shifter) {
        int sheetIndex = this.sheet.getWorkbook().getSheetIndex(this.sheet);
        List<XSSFHyperlink> hyperlinkList = this.sheet.getHyperlinkList();
        for (XSSFHyperlink hyperlink : hyperlinkList) {
            String cellRef = hyperlink.getCellRef();
            CellRangeAddress cra = CellRangeAddress.valueOf(cellRef);
            CellRangeAddress shiftedRange = XSSFRowShifter.shiftRange(shifter, cra, sheetIndex);
            if (shiftedRange == null || shiftedRange == cra) continue;
            hyperlink.setCellReference(shiftedRange.formatAsString());
        }
    }

    private static CellRangeAddress shiftRange(FormulaShifter shifter, CellRangeAddress cra, int currentExternSheetIx) {
        AreaPtg aptg = new AreaPtg(cra.getFirstRow(), cra.getLastRow(), cra.getFirstColumn(), cra.getLastColumn(), false, false, false, false);
        Ptg[] ptgs = new Ptg[]{aptg};
        if (!shifter.adjustFormula(ptgs, currentExternSheetIx)) {
            return cra;
        }
        Ptg ptg0 = ptgs[0];
        if (ptg0 instanceof AreaPtg) {
            AreaPtg bptg = (AreaPtg)ptg0;
            return new CellRangeAddress(bptg.getFirstRow(), bptg.getLastRow(), bptg.getFirstColumn(), bptg.getLastColumn());
        }
        if (ptg0 instanceof AreaErrPtg) {
            return null;
        }
        throw new IllegalStateException("Unexpected shifted ptg class (" + ptg0.getClass().getName() + ")");
    }
}

