/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.usermodel;

import com.fr.third.v2.org.apache.poi.ss.SpreadsheetVersion;
import com.fr.third.v2.org.apache.poi.ss.formula.FormulaShifter;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Cell;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellCopyPolicy;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CellStyle;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Row;
import com.fr.third.v2.org.apache.poi.ss.util.CellRangeAddress;
import com.fr.third.v2.org.apache.poi.ss.util.CellReference;
import com.fr.third.v2.org.apache.poi.util.Internal;
import com.fr.third.v2.org.apache.poi.xssf.model.CalculationChain;
import com.fr.third.v2.org.apache.poi.xssf.model.StylesTable;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCell;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.helpers.XSSFRowShifter;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFRow
implements Row,
Comparable<XSSFRow> {
    private final CTRow _row;
    private final TreeMap<Integer, XSSFCell> _cells;
    private final XSSFSheet _sheet;

    protected XSSFRow(CTRow row, XSSFSheet sheet) {
        this._row = row;
        this._sheet = sheet;
        this._cells = new TreeMap();
        for (CTCell c : row.getCArray()) {
            XSSFCell cell = new XSSFCell(this, c);
            this._cells.put(cell.getColumnIndex(), cell);
            sheet.onReadCell(cell);
        }
    }

    @Override
    public XSSFSheet getSheet() {
        return this._sheet;
    }

    @Override
    public Iterator<Cell> cellIterator() {
        return this._cells.values().iterator();
    }

    @Override
    public Iterator<Cell> iterator() {
        return this.cellIterator();
    }

    @Override
    public int compareTo(XSSFRow other) {
        if (this.getSheet() != other.getSheet()) {
            throw new IllegalArgumentException("The compared rows must belong to the same sheet");
        }
        Integer thisRow = this.getRowNum();
        Integer otherRow = other.getRowNum();
        return thisRow.compareTo(otherRow);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XSSFRow)) {
            return false;
        }
        XSSFRow other = (XSSFRow)obj;
        return this.getRowNum() == other.getRowNum() && this.getSheet() == other.getSheet();
    }

    public int hashCode() {
        return this._row.hashCode();
    }

    @Override
    public XSSFCell createCell(int columnIndex) {
        return this.createCell(columnIndex, 3);
    }

    @Override
    public XSSFCell createCell(int columnIndex, int type) {
        CTCell ctCell;
        XSSFCell prev = this._cells.get(columnIndex);
        if (prev != null) {
            ctCell = prev.getCTCell();
            ctCell.set(CTCell.Factory.newInstance());
        } else {
            ctCell = this._row.addNewC();
        }
        XSSFCell xcell = new XSSFCell(this, ctCell);
        xcell.setCellNum(columnIndex);
        if (type != 3) {
            xcell.setCellType(type);
        }
        this._cells.put(columnIndex, xcell);
        return xcell;
    }

    @Override
    public XSSFCell getCell(int cellnum) {
        return this.getCell(cellnum, this._sheet.getWorkbook().getMissingCellPolicy());
    }

    @Override
    public XSSFCell getCell(int cellnum, Row.MissingCellPolicy policy) {
        if (cellnum < 0) {
            throw new IllegalArgumentException("Cell index must be >= 0");
        }
        XSSFCell cell = this._cells.get(cellnum);
        if (policy == RETURN_NULL_AND_BLANK) {
            return cell;
        }
        if (policy == RETURN_BLANK_AS_NULL) {
            if (cell == null) {
                return cell;
            }
            if (cell.getCellType() == 3) {
                return null;
            }
            return cell;
        }
        if (policy == CREATE_NULL_AS_BLANK) {
            if (cell == null) {
                return this.createCell((short)cellnum, 3);
            }
            return cell;
        }
        throw new IllegalArgumentException("Illegal policy " + (Object)((Object)policy) + " (" + policy.id + ")");
    }

    @Override
    public short getFirstCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.firstKey());
    }

    @Override
    public short getLastCellNum() {
        return (short)(this._cells.size() == 0 ? -1 : this._cells.lastKey() + 1);
    }

    @Override
    public short getHeight() {
        return (short)(this.getHeightInPoints() * 20.0f);
    }

    @Override
    public float getHeightInPoints() {
        if (this._row.isSetHt()) {
            return (float)this._row.getHt();
        }
        return this._sheet.getDefaultRowHeightInPoints();
    }

    @Override
    public void setHeight(short height) {
        if (height == -1) {
            if (this._row.isSetHt()) {
                this._row.unsetHt();
            }
            if (this._row.isSetCustomHeight()) {
                this._row.unsetCustomHeight();
            }
        } else {
            this._row.setHt((double)height / 20.0);
            this._row.setCustomHeight(true);
        }
    }

    @Override
    public void setHeightInPoints(float height) {
        this.setHeight((short)(height == -1.0f ? -1.0f : height * 20.0f));
    }

    @Override
    public int getPhysicalNumberOfCells() {
        return this._cells.size();
    }

    @Override
    public int getRowNum() {
        return (int)(this._row.getR() - 1L);
    }

    @Override
    public void setRowNum(int rowIndex) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rowIndex + ") outside allowable range (0.." + maxrow + ")");
        }
        this._row.setR(rowIndex + 1);
    }

    @Override
    public boolean getZeroHeight() {
        return this._row.getHidden();
    }

    @Override
    public void setZeroHeight(boolean height) {
        this._row.setHidden(height);
    }

    @Override
    public boolean isFormatted() {
        return this._row.isSetS();
    }

    @Override
    public XSSFCellStyle getRowStyle() {
        if (!this.isFormatted()) {
            return null;
        }
        StylesTable stylesSource = this.getSheet().getWorkbook().getStylesSource();
        if (stylesSource.getNumCellStyles() > 0) {
            return stylesSource.getStyleAt((int)this._row.getS());
        }
        return null;
    }

    @Override
    public void setRowStyle(CellStyle style) {
        if (style == null) {
            if (this._row.isSetS()) {
                this._row.unsetS();
                this._row.unsetCustomFormat();
            }
        } else {
            StylesTable styleSource = this.getSheet().getWorkbook().getStylesSource();
            XSSFCellStyle xStyle = (XSSFCellStyle)style;
            xStyle.verifyBelongsToStylesSource(styleSource);
            long idx = styleSource.putStyle(xStyle);
            this._row.setS(idx);
            this._row.setCustomFormat(true);
        }
    }

    @Override
    public void removeCell(Cell cell) {
        if (cell.getRow() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this row");
        }
        XSSFCell xcell = (XSSFCell)cell;
        if (xcell.isPartOfArrayFormulaGroup()) {
            xcell.notifyArrayFormulaChanging();
        }
        if (cell.getCellType() == 2) {
            this._sheet.getWorkbook().onDeleteFormula(xcell);
        }
        this._cells.remove(cell.getColumnIndex());
    }

    @Internal
    public CTRow getCTRow() {
        return this._row;
    }

    protected void onDocumentWrite() {
        int i;
        boolean isOrdered = true;
        CTCell[] cArray = this._row.getCArray();
        if (cArray.length != this._cells.size()) {
            isOrdered = false;
        } else {
            i = 0;
            for (XSSFCell cell : this._cells.values()) {
                CTCell c1 = cell.getCTCell();
                CTCell c2 = cArray[i++];
                String r1 = c1.getR();
                String r2 = c2.getR();
                if (r1 != null ? r1.equals(r2) : r2 == null) continue;
                isOrdered = false;
                break;
            }
        }
        if (!isOrdered) {
            cArray = new CTCell[this._cells.size()];
            i = 0;
            for (XSSFCell xssfCell : this._cells.values()) {
                cArray[i] = (CTCell)xssfCell.getCTCell().copy();
                xssfCell.setCTCell(cArray[i]);
                ++i;
            }
            this._row.setCArray(cArray);
        }
    }

    public String toString() {
        return this._row.toString();
    }

    protected void shift(int n) {
        int rownum = this.getRowNum() + n;
        CalculationChain calcChain = this._sheet.getWorkbook().getCalculationChain();
        int sheetId = (int)this._sheet.sheet.getSheetId();
        String msg = "Row[rownum=" + this.getRowNum() + "] contains cell(s) included in a multi-cell array formula. You cannot change part of an array.";
        for (Cell c : this) {
            XSSFCell cell = (XSSFCell)c;
            if (cell.isPartOfArrayFormulaGroup()) {
                cell.notifyArrayFormulaChanging(msg);
            }
            if (calcChain != null) {
                calcChain.removeItem(sheetId, cell.getReference());
            }
            CTCell ctCell = cell.getCTCell();
            String r = new CellReference(rownum, cell.getColumnIndex()).formatAsString();
            ctCell.setR(r);
        }
        this.setRowNum(rownum);
    }

    public void copyRowFrom(Row srcRow, CellCopyPolicy policy) {
        if (srcRow == null) {
            for (Cell destCell : this) {
                Cell srcCell = null;
                ((XSSFCell)destCell).copyCellFrom(srcCell, policy);
            }
            if (policy.isCopyMergedRegions()) {
                int destRowNum = this.getRowNum();
                int index = 0;
                HashSet<Integer> indices = new HashSet<Integer>();
                for (CellRangeAddress destRegion : this.getSheet().getMergedRegions()) {
                    if (destRowNum == destRegion.getFirstRow() && destRowNum == destRegion.getLastRow()) {
                        indices.add(index);
                    }
                    ++index;
                }
                this.getSheet().removeMergedRegions(indices);
            }
            if (policy.isCopyRowHeight()) {
                this.setHeight((short)-1);
            }
        } else {
            for (Cell c : srcRow) {
                XSSFCell srcCell = (XSSFCell)c;
                XSSFCell destCell = this.createCell(srcCell.getColumnIndex(), srcCell.getCellType());
                destCell.copyCellFrom(srcCell, policy);
            }
            XSSFRowShifter rowShifter = new XSSFRowShifter(this._sheet);
            int sheetIndex = this._sheet.getWorkbook().getSheetIndex(this._sheet);
            String sheetName = this._sheet.getWorkbook().getSheetName(sheetIndex);
            int srcRowNum = srcRow.getRowNum();
            int destRowNum = this.getRowNum();
            int rowDifference = destRowNum - srcRowNum;
            FormulaShifter shifter = FormulaShifter.createForRowCopy(sheetIndex, sheetName, srcRowNum, srcRowNum, rowDifference, SpreadsheetVersion.EXCEL2007);
            rowShifter.updateRowFormulas(this, shifter);
            if (policy.isCopyMergedRegions()) {
                for (CellRangeAddress srcRegion : srcRow.getSheet().getMergedRegions()) {
                    if (srcRowNum != srcRegion.getFirstRow() || srcRowNum != srcRegion.getLastRow()) continue;
                    CellRangeAddress destRegion = srcRegion.copy();
                    destRegion.setFirstRow(destRowNum);
                    destRegion.setLastRow(destRowNum);
                    this.getSheet().addMergedRegion(destRegion);
                }
            }
            if (policy.isCopyRowHeight()) {
                this.setHeight(srcRow.getHeight());
            }
        }
    }

    @Override
    public int getOutlineLevel() {
        return this._row.getOutlineLevel();
    }
}

