/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.streaming;

import com.fr.third.v2.org.apache.poi.ss.usermodel.ClientAnchor;
import com.fr.third.v2.org.apache.poi.ss.usermodel.CreationHelper;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DataFormat;
import com.fr.third.v2.org.apache.poi.ss.usermodel.ExtendedColor;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Hyperlink;
import com.fr.third.v2.org.apache.poi.util.POILogFactory;
import com.fr.third.v2.org.apache.poi.util.POILogger;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFFormulaEvaluator;
import com.fr.third.v2.org.apache.poi.xssf.streaming.SXSSFWorkbook;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class SXSSFCreationHelper
implements CreationHelper {
    private static POILogger logger = POILogFactory.getLogger(SXSSFCreationHelper.class);
    private SXSSFWorkbook wb;
    private XSSFCreationHelper helper;

    public SXSSFCreationHelper(SXSSFWorkbook workbook) {
        this.helper = new XSSFCreationHelper(workbook.getXSSFWorkbook());
        this.wb = workbook;
    }

    public XSSFRichTextString createRichTextString(String text) {
        logger.log(3, new Object[]{"SXSSF doesn't support Rich Text Strings, any formatting information will be lost"});
        return new XSSFRichTextString(text);
    }

    public SXSSFFormulaEvaluator createFormulaEvaluator() {
        return new SXSSFFormulaEvaluator(this.wb);
    }

    public DataFormat createDataFormat() {
        return this.helper.createDataFormat();
    }

    public Hyperlink createHyperlink(int type) {
        return this.helper.createHyperlink(type);
    }

    public ExtendedColor createExtendedColor() {
        return this.helper.createExtendedColor();
    }

    public ClientAnchor createClientAnchor() {
        return this.helper.createClientAnchor();
    }
}

