/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.model;

import com.fr.third.v2.org.apache.poi.POIXMLDocumentPart;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackagePart;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageRelationship;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSheet;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSingleXmlCell;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSingleXmlCells;
import com.fr.third.v2.org.openxmlformats.schemas.spreadsheetml.x2006.main.SingleXmlCellsDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleXmlCells
extends POIXMLDocumentPart {
    private CTSingleXmlCells singleXMLCells;

    public SingleXmlCells() {
        this.singleXMLCells = CTSingleXmlCells.Factory.newInstance();
    }

    public SingleXmlCells(PackagePart part) throws IOException {
        super(part);
        this.readFrom(part.getInputStream());
    }

    @Deprecated
    public SingleXmlCells(PackagePart part, PackageRelationship rel) throws IOException {
        this(part);
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            SingleXmlCellsDocument doc = SingleXmlCellsDocument.Factory.parse(is, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            this.singleXMLCells = doc.getSingleXmlCells();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    protected void writeTo(OutputStream out) throws IOException {
        SingleXmlCellsDocument doc = SingleXmlCellsDocument.Factory.newInstance();
        doc.setSingleXmlCells(this.singleXMLCells);
        doc.save(out, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public CTSingleXmlCells getCTSingleXMLCells() {
        return this.singleXMLCells;
    }

    public List<XSSFSingleXmlCell> getAllSimpleXmlCell() {
        Vector<XSSFSingleXmlCell> list = new Vector<XSSFSingleXmlCell>();
        for (CTSingleXmlCell singleXmlCell : this.singleXMLCells.getSingleXmlCellArray()) {
            list.add(new XSSFSingleXmlCell(singleXmlCell, this));
        }
        return list;
    }
}

