/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.xssf.extractor;

import com.fr.third.v2.org.apache.poi.POITextExtractor;
import com.fr.third.v2.org.apache.poi.POIXMLProperties;
import com.fr.third.v2.org.apache.poi.POIXMLTextExtractor;
import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.ss.extractor.ExcelExtractor;
import com.fr.third.v2.org.apache.poi.ss.usermodel.DataFormatter;
import com.fr.third.v2.org.apache.poi.util.SAXHelper;
import com.fr.third.v2.org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import com.fr.third.v2.org.apache.poi.xssf.eventusermodel.XSSFReader;
import com.fr.third.v2.org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import com.fr.third.v2.org.apache.poi.xssf.model.CommentsTable;
import com.fr.third.v2.org.apache.poi.xssf.model.StylesTable;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFComment;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFShape;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSSFEventBasedExcelExtractor
extends POIXMLTextExtractor
implements ExcelExtractor {
    private OPCPackage container;
    private POIXMLProperties properties;
    private Locale locale;
    private boolean includeTextBoxes = true;
    private boolean includeSheetNames = true;
    private boolean includeCellComments = false;
    private boolean includeHeadersFooters = true;
    private boolean formulasNotResults = false;

    public XSSFEventBasedExcelExtractor(String path) throws XmlException, OpenXML4JException, IOException {
        this(OPCPackage.open(path));
    }

    public XSSFEventBasedExcelExtractor(OPCPackage container) throws XmlException, OpenXML4JException, IOException {
        super(null);
        this.container = container;
        this.properties = new POIXMLProperties(container);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Use:");
            System.err.println("  XSSFEventBasedExcelExtractor <filename.xlsx>");
            System.exit(1);
        }
        XSSFEventBasedExcelExtractor extractor = new XSSFEventBasedExcelExtractor(args[0]);
        System.out.println(((POITextExtractor)extractor).getText());
        ((POIXMLTextExtractor)extractor).close();
    }

    @Override
    public void setIncludeSheetNames(boolean includeSheetNames) {
        this.includeSheetNames = includeSheetNames;
    }

    @Override
    public void setFormulasNotResults(boolean formulasNotResults) {
        this.formulasNotResults = formulasNotResults;
    }

    @Override
    public void setIncludeHeadersFooters(boolean includeHeadersFooters) {
        this.includeHeadersFooters = includeHeadersFooters;
    }

    public void setIncludeTextBoxes(boolean includeTextBoxes) {
        this.includeTextBoxes = includeTextBoxes;
    }

    @Override
    public void setIncludeCellComments(boolean includeCellComments) {
        this.includeCellComments = includeCellComments;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public OPCPackage getPackage() {
        return this.container;
    }

    @Override
    public POIXMLProperties.CoreProperties getCoreProperties() {
        return this.properties.getCoreProperties();
    }

    @Override
    public POIXMLProperties.ExtendedProperties getExtendedProperties() {
        return this.properties.getExtendedProperties();
    }

    @Override
    public POIXMLProperties.CustomProperties getCustomProperties() {
        return this.properties.getCustomProperties();
    }

    public void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, StylesTable styles, CommentsTable comments, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = this.locale == null ? new DataFormatter() : new DataFormatter(this.locale);
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, comments, strings, sheetContentsExtractor, formatter, this.formulasNotResults);
            sheetParser.setContentHandler(handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    @Override
    public String getText() {
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.container);
            XSSFReader xssfReader = new XSSFReader(this.container);
            StylesTable styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            StringBuffer text = new StringBuffer();
            SheetTextExtractor sheetExtractor = new SheetTextExtractor();
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                if (this.includeSheetNames) {
                    text.append(iter.getSheetName());
                    text.append('\n');
                }
                CommentsTable comments = this.includeCellComments ? iter.getSheetComments() : null;
                this.processSheet(sheetExtractor, styles, comments, strings, stream);
                if (this.includeHeadersFooters) {
                    sheetExtractor.appendHeaderText(text);
                }
                sheetExtractor.appendCellText(text);
                if (this.includeTextBoxes) {
                    this.processShapes(iter.getShapes(), text);
                }
                if (this.includeHeadersFooters) {
                    sheetExtractor.appendFooterText(text);
                }
                sheetExtractor.reset();
                stream.close();
            }
            return text.toString();
        }
        catch (IOException e) {
            System.err.println(e);
            return null;
        }
        catch (SAXException se) {
            System.err.println(se);
            return null;
        }
        catch (OpenXML4JException o4je) {
            System.err.println(o4je);
            return null;
        }
    }

    private void processShapes(List<XSSFShape> shapes, StringBuffer text) {
        if (shapes == null) {
            return;
        }
        for (XSSFShape shape : shapes) {
            String sText;
            if (!(shape instanceof XSSFSimpleShape) || (sText = ((XSSFSimpleShape)shape).getText()) == null || sText.length() <= 0) continue;
            text.append(sText).append('\n');
        }
    }

    @Override
    public void close() throws IOException {
        if (this.container != null) {
            this.container.close();
            this.container = null;
        }
        super.close();
    }

    protected class SheetTextExtractor
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private final StringBuffer output = new StringBuffer();
        private boolean firstCellOfRow = true;
        private final Map<String, String> headerFooterMap;

        protected SheetTextExtractor() {
            this.headerFooterMap = XSSFEventBasedExcelExtractor.this.includeHeadersFooters ? new HashMap() : null;
        }

        public void startRow(int rowNum) {
            this.firstCellOfRow = true;
        }

        public void endRow(int rowNum) {
            this.output.append('\n');
        }

        public void cell(String cellRef, String formattedValue, XSSFComment comment) {
            if (this.firstCellOfRow) {
                this.firstCellOfRow = false;
            } else {
                this.output.append('\t');
            }
            if (formattedValue != null) {
                XSSFEventBasedExcelExtractor.this.checkMaxTextSize(this.output, formattedValue);
                this.output.append(formattedValue);
            }
            if (XSSFEventBasedExcelExtractor.this.includeCellComments && comment != null) {
                String commentText = comment.getString().getString().replace('\n', ' ');
                this.output.append(formattedValue != null ? " Comment by " : "Comment by ");
                XSSFEventBasedExcelExtractor.this.checkMaxTextSize(this.output, commentText);
                if (commentText.startsWith(comment.getAuthor() + ": ")) {
                    this.output.append(commentText);
                } else {
                    this.output.append(comment.getAuthor()).append(": ").append(commentText);
                }
            }
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
            if (this.headerFooterMap != null) {
                this.headerFooterMap.put(tagName, text);
            }
        }

        private void appendHeaderFooterText(StringBuffer buffer, String name) {
            String text = this.headerFooterMap.get(name);
            if (text != null && text.length() > 0) {
                text = this.handleHeaderFooterDelimiter(text, "&L");
                text = this.handleHeaderFooterDelimiter(text, "&C");
                text = this.handleHeaderFooterDelimiter(text, "&R");
                buffer.append(text).append('\n');
            }
        }

        private String handleHeaderFooterDelimiter(String text, String delimiter) {
            int index = text.indexOf(delimiter);
            if (index == 0) {
                text = text.substring(2);
            } else if (index > 0) {
                text = text.substring(0, index) + "\t" + text.substring(index + 2);
            }
            return text;
        }

        private void appendHeaderText(StringBuffer buffer) {
            this.appendHeaderFooterText(buffer, "firstHeader");
            this.appendHeaderFooterText(buffer, "oddHeader");
            this.appendHeaderFooterText(buffer, "evenHeader");
        }

        private void appendFooterText(StringBuffer buffer) {
            this.appendHeaderFooterText(buffer, "firstFooter");
            this.appendHeaderFooterText(buffer, "oddFooter");
            this.appendHeaderFooterText(buffer, "evenFooter");
        }

        private void appendCellText(StringBuffer buffer) {
            XSSFEventBasedExcelExtractor.this.checkMaxTextSize(buffer, this.output.toString());
            buffer.append(this.output);
        }

        private void reset() {
            this.output.setLength(0);
            this.firstCellOfRow = true;
            if (this.headerFooterMap != null) {
                this.headerFooterMap.clear();
            }
        }
    }
}

