/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.util;

import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.xmlbeans.XmlCursor;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import com.fr.third.v2.org.apache.xmlbeans.XmlObject;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlSort {
    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.out.println("    java XmlSort <XML_File> [<XPath>]");
            return;
        }
        File f = new File(args[0]);
        try {
            XmlObject docInstance = XmlObject.Factory.parse(f, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
            XmlObject element = null;
            if (args.length > 1) {
                String xpath = args[1];
                XmlObject[] result = docInstance.selectPath(xpath);
                if (result.length == 0) {
                    System.out.println("ERROR: XPath \"" + xpath + "\" did not return any results");
                } else if (result.length > 1) {
                    System.out.println("ERROR: XPath \"" + xpath + "\" returned more than one node (" + result.length + ")");
                } else {
                    element = result[0];
                }
            } else {
                XmlCursor c = docInstance.newCursor();
                c.toFirstChild();
                element = c.getObject();
                c.dispose();
            }
            if (element != null) {
                XmlSort.sort(element, new QNameComparator(1));
            }
            System.out.println(docInstance.xmlText());
        }
        catch (IOException ioe) {
            System.out.println("ERROR: Could not open file: \"" + args[0] + "\": " + ioe.getMessage());
        }
        catch (XmlException xe) {
            System.out.println("ERROR: Could not parse file: \"" + args[0] + "\": " + xe.getMessage());
        }
    }

    public static void sort(XmlObject element, Comparator<XmlCursor> comp) {
        XmlCursor headCursor = element.newCursor();
        if (!headCursor.isStart()) {
            throw new IllegalStateException("The element parameter must point to a STARTDOC");
        }
        boolean moved = headCursor.toFirstChild();
        if (!moved) {
            return;
        }
        XmlCursor listCursor = headCursor.newCursor();
        boolean moreElements = listCursor.toNextSibling();
        while (moreElements) {
            moved = false;
            while (headCursor.comparePosition(listCursor) < 0) {
                if (comp.compare(headCursor, listCursor) > 0) {
                    listCursor.moveXml(headCursor);
                    while (!listCursor.isStart() && !listCursor.isEnd()) {
                        listCursor.moveXml(headCursor);
                    }
                    moreElements = listCursor.isStart();
                    moved = true;
                    break;
                }
                headCursor.toNextSibling();
            }
            if (!moved) {
                moreElements = listCursor.toNextSibling();
            }
            headCursor.toParent();
            headCursor.toFirstChild();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class QNameComparator
    implements Comparator<XmlCursor> {
        public static final int ASCENDING = 1;
        public static final int DESCENDING = 2;
        private int order;

        public QNameComparator(int order) {
            this.order = order;
            if (order != 1 && order != 2) {
                throw new IllegalArgumentException("Please specify one of ASCENDING or DESCENDING comparison orders");
            }
        }

        @Override
        public int compare(XmlCursor cursor1, XmlCursor cursor2) {
            QName qname1 = cursor1.getName();
            QName qname2 = cursor2.getName();
            int qnameComparisonRes = qname1.getNamespaceURI().compareTo(qname2.getNamespaceURI());
            if (qnameComparisonRes == 0) {
                return this.order == 1 ? qname1.getLocalPart().compareTo(qname2.getLocalPart()) : -qname1.getLocalPart().compareTo(qname2.getLocalPart());
            }
            return this.order == 1 ? qnameComparisonRes : -qnameComparisonRes;
        }
    }
}

