/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.util;

import com.fr.third.v2.org.apache.poi.util.SuppressForbidden;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class LocaleUtil {
    public static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
    public static final Charset CHARSET_1252 = Charset.forName("CP1252");
    private static final ThreadLocal<TimeZone> userTimeZone = new ThreadLocal<TimeZone>(){

        @Override
        @SuppressForbidden(value="implementation around default locales in POI")
        protected TimeZone initialValue() {
            return TimeZone.getDefault();
        }
    };
    private static final ThreadLocal<Locale> userLocale = new ThreadLocal<Locale>(){

        @Override
        @SuppressForbidden(value="implementation around default locales in POI")
        protected Locale initialValue() {
            return Locale.getDefault();
        }
    };

    public static void setUserTimeZone(TimeZone timezone) {
        userTimeZone.set(timezone);
    }

    public static TimeZone getUserTimeZone() {
        return userTimeZone.get();
    }

    public static void setUserLocale(Locale locale) {
        userLocale.set(locale);
    }

    public static Locale getUserLocale() {
        return userLocale.get();
    }

    public static Calendar getLocaleCalendar() {
        return LocaleUtil.getLocaleCalendar(LocaleUtil.getUserTimeZone());
    }

    public static Calendar getLocaleCalendar(int year, int month, int day) {
        return LocaleUtil.getLocaleCalendar(year, month, day, 0, 0, 0);
    }

    public static Calendar getLocaleCalendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar cal = LocaleUtil.getLocaleCalendar();
        cal.set(year, month, day, hour, minute, second);
        cal.clear(14);
        return cal;
    }

    public static Calendar getLocaleCalendar(TimeZone timeZone) {
        return Calendar.getInstance(timeZone, LocaleUtil.getUserLocale());
    }
}

