/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.usermodel;

import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.POIXMLDocument;
import com.fr.third.v2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import com.fr.third.v2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.OPCPackage;
import com.fr.third.v2.org.apache.poi.openxml4j.opc.PackageAccess;
import com.fr.third.v2.org.apache.poi.poifs.crypt.Decryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import com.fr.third.v2.org.apache.poi.ss.usermodel.Workbook;
import com.fr.third.v2.org.apache.poi.util.IOUtils;
import com.fr.third.v2.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.security.GeneralSecurityException;

public class WorkbookFactory {
    public static Workbook create(POIFSFileSystem fs) throws IOException {
        return new HSSFWorkbook(fs);
    }

    public static Workbook create(NPOIFSFileSystem fs) throws IOException {
        try {
            return WorkbookFactory.create(fs, null);
        }
        catch (InvalidFormatException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Workbook create(NPOIFSFileSystem fs, String password) throws IOException, InvalidFormatException {
        DirectoryNode root = fs.getRoot();
        if (root.hasEntry("EncryptedPackage")) {
            EncryptionInfo info = new EncryptionInfo(fs);
            Decryptor d = Decryptor.getInstance(info);
            boolean passwordCorrect = false;
            InputStream stream = null;
            try {
                if (password != null && d.verifyPassword(password)) {
                    passwordCorrect = true;
                }
                if (!passwordCorrect && d.verifyPassword("VelvetSweatshop")) {
                    passwordCorrect = true;
                }
                if (passwordCorrect) {
                    stream = d.getDataStream(root);
                }
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            if (!passwordCorrect) {
                if (password != null) {
                    throw new EncryptedDocumentException("Password incorrect");
                }
                throw new EncryptedDocumentException("The supplied spreadsheet is protected, but no password was supplied");
            }
            OPCPackage pkg = OPCPackage.open(stream);
            return WorkbookFactory.create(pkg);
        }
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
        }
        try {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(root, true);
            return hSSFWorkbook;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static Workbook create(OPCPackage pkg) throws IOException {
        return new XSSFWorkbook(pkg);
    }

    public static Workbook create(InputStream inp) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(inp, null);
    }

    public static Workbook create(InputStream inp, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        byte[] header8;
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(header8 = IOUtils.peekFirst8Bytes(inp))) {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(inp);
            return WorkbookFactory.create(fs, password);
        }
        if (POIXMLDocument.hasOOXMLHeader(inp)) {
            return new XSSFWorkbook(OPCPackage.open(inp));
        }
        throw new InvalidFormatException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static Workbook create(File file) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, null);
    }

    public static Workbook create(File file, String password) throws IOException, InvalidFormatException, EncryptedDocumentException {
        return WorkbookFactory.create(file, password, false);
    }

    public static Workbook create(File file, String password, boolean readOnly) throws IOException, InvalidFormatException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        try {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(file, readOnly);
            try {
                return WorkbookFactory.create(fs, password);
            }
            catch (RuntimeException e) {
                fs.close();
                throw e;
            }
        }
        catch (OfficeXmlFileException e) {
            OPCPackage pkg = OPCPackage.open(file, readOnly ? PackageAccess.READ : PackageAccess.READ_WRITE);
            try {
                return new XSSFWorkbook(pkg);
            }
            catch (IOException ioe) {
                pkg.revert();
                throw ioe;
            }
            catch (RuntimeException ioe) {
                pkg.revert();
                throw ioe;
            }
        }
    }
}

