/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.ss.usermodel;

import com.fr.third.v2.org.apache.poi.ss.formula.eval.ErrorEval;

public final class CellValue {
    public static final CellValue TRUE = new CellValue(4, 0.0, true, null, 0);
    public static final CellValue FALSE = new CellValue(4, 0.0, false, null, 0);
    private final int _cellType;
    private final double _numberValue;
    private final boolean _booleanValue;
    private final String _textValue;
    private final int _errorCode;

    private CellValue(int cellType, double numberValue, boolean booleanValue, String textValue, int errorCode) {
        this._cellType = cellType;
        this._numberValue = numberValue;
        this._booleanValue = booleanValue;
        this._textValue = textValue;
        this._errorCode = errorCode;
    }

    public CellValue(double numberValue) {
        this(0, numberValue, false, null, 0);
    }

    public static CellValue valueOf(boolean booleanValue) {
        return booleanValue ? TRUE : FALSE;
    }

    public CellValue(String stringValue) {
        this(1, 0.0, false, stringValue, 0);
    }

    public static CellValue getError(int errorCode) {
        return new CellValue(5, 0.0, false, null, errorCode);
    }

    public boolean getBooleanValue() {
        return this._booleanValue;
    }

    public double getNumberValue() {
        return this._numberValue;
    }

    public String getStringValue() {
        return this._textValue;
    }

    public int getCellType() {
        return this._cellType;
    }

    public byte getErrorValue() {
        return (byte)this._errorCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    public String formatAsString() {
        switch (this._cellType) {
            case 0: {
                return String.valueOf(this._numberValue);
            }
            case 1: {
                return '\"' + this._textValue + '\"';
            }
            case 4: {
                return this._booleanValue ? "TRUE" : "FALSE";
            }
            case 5: {
                return ErrorEval.getText(this._errorCode);
            }
        }
        return "<error unexpected cell type " + this._cellType + ">";
    }
}

