/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.usermodel;

import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.OldFileFormatException;
import com.fr.third.v2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import com.fr.third.v2.org.apache.poi.poifs.crypt.Decryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import com.fr.third.v2.org.apache.poi.sl.usermodel.SlideShow;
import com.fr.third.v2.org.apache.poi.util.IOUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlideShowFactory {
    private static final byte[] OOXML_FILE_HEADER = new byte[]{80, 75, 3, 4};

    public static SlideShow<?, ?> create(NPOIFSFileSystem fs) throws IOException {
        return SlideShowFactory.create(fs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlideShow<?, ?> create(NPOIFSFileSystem fs, String password) throws IOException {
        DirectoryNode root = fs.getRoot();
        if (root.hasEntry("EncryptedPackage")) {
            EncryptionInfo info = new EncryptionInfo(fs);
            Decryptor d = Decryptor.getInstance(info);
            boolean passwordCorrect = false;
            InputStream stream = null;
            try {
                if (password != null && d.verifyPassword(password)) {
                    passwordCorrect = true;
                }
                if (!passwordCorrect && d.verifyPassword("VelvetSweatshop")) {
                    passwordCorrect = true;
                }
                if (passwordCorrect) {
                    stream = d.getDataStream(root);
                }
                if (!passwordCorrect) {
                    String err = password != null ? "Password incorrect" : "The supplied spreadsheet is protected, but no password was supplied";
                    throw new EncryptedDocumentException(err);
                }
                SlideShow<?, ?> err = SlideShowFactory.createXSLFSlideShow(stream);
                return err;
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
        }
        try {
            SlideShow<?, ?> slideShow = SlideShowFactory.createHSLFSlideShow(fs);
            return slideShow;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static SlideShow<?, ?> create(InputStream inp) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(inp, null);
    }

    public static SlideShow<?, ?> create(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        byte[] header8;
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(header8 = IOUtils.peekFirst8Bytes(inp))) {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(inp);
            return SlideShowFactory.create(fs, password);
        }
        if (SlideShowFactory.hasOOXMLHeader(inp)) {
            return SlideShowFactory.createXSLFSlideShow(inp);
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static SlideShow<?, ?> create(File file) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, null);
    }

    public static SlideShow<?, ?> create(File file, String password) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, password, false);
    }

    public static SlideShow<?, ?> create(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        NPOIFSFileSystem fs = null;
        try {
            fs = new NPOIFSFileSystem(file, readOnly);
            return SlideShowFactory.create(fs, password);
        }
        catch (OfficeXmlFileException e) {
            if (fs != null) {
                fs.close();
            }
            return SlideShowFactory.createXSLFSlideShow(file, readOnly);
        }
        catch (RuntimeException e) {
            if (fs != null) {
                fs.close();
            }
            throw e;
        }
    }

    protected static SlideShow<?, ?> createHSLFSlideShow(Object ... args) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.hslf.usermodel.HSLFSlideShowFactory", args);
    }

    protected static SlideShow<?, ?> createXSLFSlideShow(Object ... args) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.xslf.usermodel.XSLFSlideShowFactory", args);
    }

    protected static SlideShow<?, ?> createSlideShow(String factoryClass, Object[] args) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            Class[] argsClz = new Class[args.length];
            int i = 0;
            for (Object o : args) {
                Class<Object> c = o.getClass();
                if (Boolean.class.isAssignableFrom(c)) {
                    c = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(c)) {
                    c = InputStream.class;
                }
                argsClz[i++] = c;
            }
            Method m = clazz.getMethod("createSlideShow", argsClz);
            return (SlideShow)m.invoke(null, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)t;
            }
            if (t instanceof OldFileFormatException) {
                throw (OldFileFormatException)t;
            }
            throw new IOException(t);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected static boolean hasOOXMLHeader(InputStream inp) throws IOException {
        inp.mark(4);
        byte[] header = new byte[4];
        int bytesRead = IOUtils.readFully(inp, header);
        if (inp instanceof PushbackInputStream) {
            PushbackInputStream pin = (PushbackInputStream)inp;
            pin.unread(header, 0, bytesRead);
        } else {
            inp.reset();
        }
        return bytesRead == 4 && header[0] == OOXML_FILE_HEADER[0] && header[1] == OOXML_FILE_HEADER[1] && header[2] == OOXML_FILE_HEADER[2] && header[3] == OOXML_FILE_HEADER[3];
    }
}

