/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw.geom;

import com.fr.third.v2.org.apache.poi.sl.draw.geom.AbsExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.AddDivideExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.AddSubtractExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.ArcTanExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.CosExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.CosineArcTanExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.Expression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.IfElseExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.LiteralValueExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.MaxExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.MinExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.ModExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.MultiplyDivideExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.PinExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.SinArcTanExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.SinExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.SqrtExpression;
import com.fr.third.v2.org.apache.poi.sl.draw.geom.TanExpression;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionParser {
    static final HashMap<String, Class<? extends Expression>> impls = new HashMap();

    public static Expression parse(String str) {
        for (String regexp : impls.keySet()) {
            Pattern ptrn = Pattern.compile(regexp);
            Matcher m = ptrn.matcher(str);
            if (!m.matches()) continue;
            Class<? extends Expression> c = impls.get(regexp);
            try {
                return c.getDeclaredConstructor(Matcher.class).newInstance(m);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unsupported formula: " + str);
    }

    static {
        impls.put("\\*/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", MultiplyDivideExpression.class);
        impls.put("\\+- +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)( 0)?", AddSubtractExpression.class);
        impls.put("\\+/ +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", AddDivideExpression.class);
        impls.put("\\?: +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", IfElseExpression.class);
        impls.put("val +([\\-\\w]+)", LiteralValueExpression.class);
        impls.put("abs +([\\-\\w]+)", AbsExpression.class);
        impls.put("sqrt +([\\-\\w]+)", SqrtExpression.class);
        impls.put("max +([\\-\\w]+) +([\\-\\w]+)", MaxExpression.class);
        impls.put("min +([\\-\\w]+) +([\\-\\w]+)", MinExpression.class);
        impls.put("at2 +([\\-\\w]+) +([\\-\\w]+)", ArcTanExpression.class);
        impls.put("sin +([\\-\\w]+) +([\\-\\w]+)", SinExpression.class);
        impls.put("cos +([\\-\\w]+) +([\\-\\w]+)", CosExpression.class);
        impls.put("tan +([\\-\\w]+) +([\\-\\w]+)", TanExpression.class);
        impls.put("cat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", CosineArcTanExpression.class);
        impls.put("sat2 +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", SinArcTanExpression.class);
        impls.put("pin +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", PinExpression.class);
        impls.put("mod +([\\-\\w]+) +([\\-\\w]+) +([\\-\\w]+)", ModExpression.class);
    }
}

