/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.sl.draw;

import com.fr.third.v2.org.apache.poi.sl.draw.DrawFactory;
import com.fr.third.v2.org.apache.poi.sl.draw.DrawMasterSheet;
import com.fr.third.v2.org.apache.poi.sl.draw.Drawable;
import com.fr.third.v2.org.apache.poi.sl.usermodel.MasterSheet;
import com.fr.third.v2.org.apache.poi.sl.usermodel.Shape;
import com.fr.third.v2.org.apache.poi.sl.usermodel.Sheet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawSheet
implements Drawable {
    protected final Sheet<?, ?> sheet;

    public DrawSheet(Sheet<?, ?> sheet) {
        this.sheet = sheet;
    }

    @Override
    public void draw(Graphics2D graphics) {
        Dimension dim = this.sheet.getSlideShow().getPageSize();
        Color whiteTrans = new Color(1.0f, 1.0f, 1.0f, 0.0f);
        graphics.setColor(whiteTrans);
        graphics.fillRect(0, 0, (int)dim.getWidth(), (int)dim.getHeight());
        DrawFactory drawFact = DrawFactory.getInstance(graphics);
        MasterSheet<?, ?> master = this.sheet.getMasterSheet();
        if (this.sheet.getFollowMasterGraphics() && master != null) {
            DrawMasterSheet drawer = drawFact.getDrawable(master);
            drawer.draw(graphics);
        }
        graphics.setRenderingHint(Drawable.GROUP_TRANSFORM, new AffineTransform());
        for (Shape shape : this.sheet.getShapes()) {
            if (!this.canDraw(shape)) continue;
            AffineTransform at = graphics.getTransform();
            graphics.setRenderingHint(Drawable.GSAVE, true);
            Drawable drawer = drawFact.getDrawable(shape);
            drawer.applyTransform(graphics);
            drawer.draw(graphics);
            graphics.setTransform(at);
            graphics.setRenderingHint(Drawable.GRESTORE, true);
        }
    }

    @Override
    public void applyTransform(Graphics2D context) {
    }

    @Override
    public void drawContent(Graphics2D context) {
    }

    protected boolean canDraw(Shape<?, ?> shape) {
        return true;
    }
}

