/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.poifs.property;

import com.fr.third.v2.org.apache.poi.poifs.property.DirectoryProperty;
import com.fr.third.v2.org.apache.poi.poifs.property.DocumentProperty;
import com.fr.third.v2.org.apache.poi.poifs.property.Property;
import com.fr.third.v2.org.apache.poi.poifs.property.RootProperty;
import com.fr.third.v2.org.apache.poi.poifs.storage.ListManagedBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyFactory {
    private PropertyFactory() {
    }

    static List<Property> convertToProperties(ListManagedBlock[] blocks) throws IOException {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int j = 0; j < blocks.length; ++j) {
            byte[] data = blocks[j].getData();
            PropertyFactory.convertToProperties(data, properties);
        }
        return properties;
    }

    static void convertToProperties(byte[] data, List<Property> properties) throws IOException {
        int property_count = data.length / 128;
        int offset = 0;
        for (int k = 0; k < property_count; ++k) {
            switch (data[offset + 66]) {
                case 1: {
                    properties.add(new DirectoryProperty(properties.size(), data, offset));
                    break;
                }
                case 2: {
                    properties.add(new DocumentProperty(properties.size(), data, offset));
                    break;
                }
                case 5: {
                    properties.add(new RootProperty(properties.size(), data, offset));
                    break;
                }
                default: {
                    properties.add(null);
                }
            }
            offset += 128;
        }
    }
}

