/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.poifs.crypt.cryptoapi;

import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.hpsf.DocumentSummaryInformation;
import com.fr.third.v2.org.apache.poi.hpsf.PropertySetFactory;
import com.fr.third.v2.org.apache.poi.hpsf.WritingNotSupportedException;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CryptoFunctions;
import com.fr.third.v2.org.apache.poi.poifs.crypt.DataSpaceMapUtils;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.fr.third.v2.org.apache.poi.poifs.crypt.Encryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.HashAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionHeader;
import com.fr.third.v2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionInfoBuilder;
import com.fr.third.v2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionVerifier;
import com.fr.third.v2.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DirectoryNode;
import com.fr.third.v2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import com.fr.third.v2.org.apache.poi.util.IOUtils;
import com.fr.third.v2.org.apache.poi.util.LittleEndian;
import com.fr.third.v2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import com.fr.third.v2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class CryptoAPIEncryptor
extends Encryptor {
    private final CryptoAPIEncryptionInfoBuilder builder;

    protected CryptoAPIEncryptor(CryptoAPIEncryptionInfoBuilder builder) {
        this.builder = builder;
    }

    public void confirmPassword(String password) {
        SecureRandom r = new SecureRandom();
        byte[] salt = new byte[16];
        byte[] verifier = new byte[16];
        ((Random)r).nextBytes(salt);
        ((Random)r).nextBytes(verifier);
        this.confirmPassword(password, null, null, verifier, salt, null);
    }

    public void confirmPassword(String password, byte[] keySpec, byte[] keySalt, byte[] verifier, byte[] verifierSalt, byte[] integritySalt) {
        assert (verifier != null && verifierSalt != null);
        CryptoAPIEncryptionVerifier ver = this.builder.getVerifier();
        ver.setSalt(verifierSalt);
        SecretKey skey = CryptoAPIDecryptor.generateSecretKey(password, ver);
        this.setSecretKey(skey);
        try {
            Cipher cipher = this.initCipherForBlock(null, 0);
            byte[] encryptedVerifier = new byte[verifier.length];
            cipher.update(verifier, 0, verifier.length, encryptedVerifier);
            ver.setEncryptedVerifier(encryptedVerifier);
            HashAlgorithm hashAlgo = ver.getHashAlgorithm();
            MessageDigest hashAlg = CryptoFunctions.getMessageDigest(hashAlgo);
            byte[] calcVerifierHash = hashAlg.digest(verifier);
            byte[] encryptedVerifierHash = cipher.doFinal(calcVerifierHash);
            ver.setEncryptedVerifierHash(encryptedVerifierHash);
        }
        catch (GeneralSecurityException e) {
            throw new EncryptedDocumentException("Password confirmation failed", e);
        }
    }

    public Cipher initCipherForBlock(Cipher cipher, int block) throws GeneralSecurityException {
        return CryptoAPIDecryptor.initCipherForBlock(cipher, block, this.builder, this.getSecretKey(), 1);
    }

    public OutputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        CipherByteArrayOutputStream bos = new CipherByteArrayOutputStream();
        byte[] buf = new byte[8];
        bos.write(buf, 0, 8);
        String[] entryNames = new String[]{"\u0005SummaryInformation", "\u0005DocumentSummaryInformation"};
        ArrayList<CryptoAPIDecryptor.StreamDescriptorEntry> descList = new ArrayList<CryptoAPIDecryptor.StreamDescriptorEntry>();
        int block = 0;
        for (String entryName : entryNames) {
            if (!dir.hasEntry(entryName)) continue;
            CryptoAPIDecryptor.StreamDescriptorEntry descEntry = new CryptoAPIDecryptor.StreamDescriptorEntry();
            descEntry.block = block;
            descEntry.streamOffset = bos.size();
            descEntry.streamName = entryName;
            descEntry.flags = CryptoAPIDecryptor.StreamDescriptorEntry.flagStream.setValue(0, 1);
            descEntry.reserved2 = 0;
            bos.setBlock(block);
            DocumentInputStream dis = dir.createDocumentInputStream(entryName);
            IOUtils.copy(dis, bos);
            dis.close();
            descEntry.streamSize = bos.size() - descEntry.streamOffset;
            descList.add(descEntry);
            dir.getEntry(entryName).delete();
            ++block;
        }
        int streamDescriptorArrayOffset = bos.size();
        bos.setBlock(0);
        LittleEndian.putUInt(buf, 0, descList.size());
        bos.write(buf, 0, 4);
        for (CryptoAPIDecryptor.StreamDescriptorEntry sde : descList) {
            LittleEndian.putUInt(buf, 0, sde.streamOffset);
            bos.write(buf, 0, 4);
            LittleEndian.putUInt(buf, 0, sde.streamSize);
            bos.write(buf, 0, 4);
            LittleEndian.putUShort(buf, 0, sde.block);
            bos.write(buf, 0, 2);
            LittleEndian.putUByte(buf, 0, (short)sde.streamName.length());
            bos.write(buf, 0, 1);
            LittleEndian.putUByte(buf, 0, (short)sde.flags);
            bos.write(buf, 0, 1);
            LittleEndian.putUInt(buf, 0, sde.reserved2);
            bos.write(buf, 0, 4);
            byte[] nameBytes = StringUtil.getToUnicodeLE(sde.streamName);
            bos.write(nameBytes, 0, nameBytes.length);
            LittleEndian.putShort(buf, 0, (short)0);
            bos.write(buf, 0, 2);
        }
        int savedSize = bos.size();
        int streamDescriptorArraySize = savedSize - streamDescriptorArrayOffset;
        LittleEndian.putUInt(buf, 0, streamDescriptorArrayOffset);
        LittleEndian.putUInt(buf, 4, streamDescriptorArraySize);
        bos.reset();
        bos.setBlock(0);
        bos.write(buf, 0, 8);
        bos.setSize(savedSize);
        dir.createDocument("EncryptedSummary", new ByteArrayInputStream(bos.getBuf(), 0, savedSize));
        DocumentSummaryInformation dsi = PropertySetFactory.newDocumentSummaryInformation();
        try {
            dsi.write(dir, "\u0005DocumentSummaryInformation");
        }
        catch (WritingNotSupportedException e) {
            throw new IOException(e);
        }
        return bos;
    }

    protected int getKeySizeInBytes() {
        return this.builder.getHeader().getKeySize() / 8;
    }

    protected void createEncryptionInfoEntry(DirectoryNode dir) throws IOException {
        DataSpaceMapUtils.addDefaultDataSpace(dir);
        final EncryptionInfo info = this.builder.getEncryptionInfo();
        final CryptoAPIEncryptionHeader header = this.builder.getHeader();
        final CryptoAPIEncryptionVerifier verifier = this.builder.getVerifier();
        EncryptionRecord er = new EncryptionRecord(){

            public void write(LittleEndianByteArrayOutputStream bos) {
                bos.writeShort(info.getVersionMajor());
                bos.writeShort(info.getVersionMinor());
                header.write(bos);
                verifier.write(bos);
            }
        };
        DataSpaceMapUtils.createEncryptionEntry(dir, "EncryptionInfo", er);
    }

    private class CipherByteArrayOutputStream
    extends ByteArrayOutputStream {
        Cipher cipher;
        byte[] oneByte = new byte[]{0};

        public CipherByteArrayOutputStream() throws GeneralSecurityException {
            this.setBlock(0);
        }

        public byte[] getBuf() {
            return this.buf;
        }

        public void setSize(int count) {
            this.count = count;
        }

        public void setBlock(int block) throws GeneralSecurityException {
            this.cipher = CryptoAPIEncryptor.this.initCipherForBlock(this.cipher, block);
        }

        public void write(int b) {
            try {
                this.oneByte[0] = (byte)b;
                this.cipher.update(this.oneByte, 0, 1, this.oneByte, 0);
                super.write(this.oneByte);
            }
            catch (Exception e) {
                throw new EncryptedDocumentException(e);
            }
        }

        public void write(byte[] b, int off, int len) {
            try {
                this.cipher.update(b, off, len, b, off);
                super.write(b, off, len);
            }
            catch (Exception e) {
                throw new EncryptedDocumentException(e);
            }
        }
    }
}

