/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.poifs.crypt.agile;

import com.fr.third.v2.com.microsoft.schemas.office.x2006.encryption.EncryptionDocument;
import com.fr.third.v2.org.apache.poi.EncryptedDocumentException;
import com.fr.third.v2.org.apache.poi.POIXMLTypeLoader;
import com.fr.third.v2.org.apache.poi.poifs.crypt.ChainingMode;
import com.fr.third.v2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfo;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import com.fr.third.v2.org.apache.poi.poifs.crypt.EncryptionMode;
import com.fr.third.v2.org.apache.poi.poifs.crypt.HashAlgorithm;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileDecryptor;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptionHeader;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptionVerifier;
import com.fr.third.v2.org.apache.poi.poifs.crypt.agile.AgileEncryptor;
import com.fr.third.v2.org.apache.poi.util.LittleEndianInput;
import com.fr.third.v2.org.apache.xmlbeans.XmlException;
import java.io.IOException;
import java.io.InputStream;

public class AgileEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    AgileEncryptionHeader header;
    AgileEncryptionVerifier verifier;
    AgileDecryptor decryptor;
    AgileEncryptor encryptor;

    public void initialize(EncryptionInfo info, LittleEndianInput dis) throws IOException {
        this.info = info;
        EncryptionDocument ed = AgileEncryptionInfoBuilder.parseDescriptor((InputStream)((Object)dis));
        this.header = new AgileEncryptionHeader(ed);
        this.verifier = new AgileEncryptionVerifier(ed);
        if (info.getVersionMajor() == EncryptionMode.agile.versionMajor && info.getVersionMinor() == EncryptionMode.agile.versionMinor) {
            this.decryptor = new AgileDecryptor(this);
            this.encryptor = new AgileEncryptor(this);
        }
    }

    public void initialize(EncryptionInfo info, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        this.info = info;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.aes128;
        }
        if (cipherAlgorithm == CipherAlgorithm.rc4) {
            throw new EncryptedDocumentException("RC4 must not be used with agile encryption.");
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (chainingMode == null) {
            chainingMode = ChainingMode.cbc;
        }
        if (chainingMode != ChainingMode.cbc && chainingMode != ChainingMode.cfb) {
            throw new EncryptedDocumentException("Agile encryption only supports CBC/CFB chaining.");
        }
        if (keyBits == -1) {
            keyBits = cipherAlgorithm.defaultKeySize;
        }
        if (blockSize == -1) {
            blockSize = cipherAlgorithm.blockSize;
        }
        boolean found = false;
        for (int ks : cipherAlgorithm.allowedKeySize) {
            found |= ks == keyBits;
        }
        if (!found) {
            throw new EncryptedDocumentException("KeySize " + keyBits + " not allowed for Cipher " + cipherAlgorithm.toString());
        }
        this.header = new AgileEncryptionHeader(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.verifier = new AgileEncryptionVerifier(cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.decryptor = new AgileDecryptor(this);
        this.encryptor = new AgileEncryptor(this);
    }

    public AgileEncryptionHeader getHeader() {
        return this.header;
    }

    public AgileEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public AgileDecryptor getDecryptor() {
        return this.decryptor;
    }

    public AgileEncryptor getEncryptor() {
        return this.encryptor;
    }

    protected EncryptionInfo getInfo() {
        return this.info;
    }

    protected static EncryptionDocument parseDescriptor(String descriptor) {
        try {
            return EncryptionDocument.Factory.parse(descriptor, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        }
        catch (XmlException e) {
            throw new EncryptedDocumentException("Unable to parse encryption descriptor", e);
        }
    }

    protected static EncryptionDocument parseDescriptor(InputStream descriptor) {
        try {
            return EncryptionDocument.Factory.parse(descriptor, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        }
        catch (Exception e) {
            throw new EncryptedDocumentException("Unable to parse encryption descriptor", e);
        }
    }
}

