/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.v2.org.apache.poi.openxml4j.opc.internal;

import com.fr.third.v2.org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ContentType {
    private String type;
    private String subType;
    private Hashtable<String, String> parameters;
    private static final Pattern patternTypeSubType;
    private static final Pattern patternTypeSubTypeParams;
    private static final Pattern patternParams;

    public ContentType(String contentType) throws InvalidFormatException {
        Matcher mMediaType = patternTypeSubType.matcher(contentType);
        if (!mMediaType.matches()) {
            mMediaType = patternTypeSubTypeParams.matcher(contentType);
        }
        if (!mMediaType.matches()) {
            throw new InvalidFormatException("The specified content type '" + contentType + "' is not compliant with RFC 2616: malformed content type.");
        }
        if (mMediaType.groupCount() >= 2) {
            this.type = mMediaType.group(1);
            this.subType = mMediaType.group(2);
            this.parameters = new Hashtable(1);
            if (mMediaType.groupCount() >= 5) {
                Matcher mParams = patternParams.matcher(contentType.substring(mMediaType.end(2)));
                while (mParams.find()) {
                    this.parameters.put(mParams.group(1), mParams.group(2));
                }
            }
        }
    }

    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean withParameters) {
        StringBuffer retVal = new StringBuffer();
        retVal.append(this.getType());
        retVal.append("/");
        retVal.append(this.getSubType());
        if (withParameters) {
            for (String key : this.parameters.keySet()) {
                retVal.append(";");
                retVal.append(key);
                retVal.append("=");
                retVal.append(this.parameters.get(key));
            }
        }
        return retVal.toString();
    }

    public boolean equals(Object obj) {
        return !(obj instanceof ContentType) || this.toString().equalsIgnoreCase(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.parameters.isEmpty();
    }

    public String[] getParameterKeys() {
        if (this.parameters == null) {
            return new String[0];
        }
        return this.parameters.keySet().toArray(new String[this.parameters.size()]);
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }

    public String getParameters(String key) {
        return this.getParameter(key);
    }

    static {
        String token = "[\\x21-\\x7E&&[^\\(\\)<>@,;:\\\\/\"\\[\\]\\?={}\\x20\\x09]]";
        String parameter = "(" + token + "+)=(\"?" + token + "+\"?)";
        patternTypeSubType = Pattern.compile("^(" + token + "+)/(" + token + "+)$");
        patternTypeSubTypeParams = Pattern.compile("^(" + token + "+)/(" + token + "+)(;" + parameter + ")*$");
        patternParams = Pattern.compile(";" + parameter);
    }
}

